/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.locking.consistentkey;

import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.locking.consistentkey.ConsistentKeyLockerSerializer;
import org.janusgraph.diskstorage.locking.consistentkey.LockCleanerService;
import org.janusgraph.diskstorage.locking.consistentkey.StandardLockCleanerRunnable;
import org.janusgraph.diskstorage.util.KeyColumn;
import org.janusgraph.diskstorage.util.UncaughtExceptionLogger;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardLockCleanerService
implements LockCleanerService {
    private static final long KEEPALIVE_TIME = 5L;
    private static final TimeUnit KEEPALIVE_UNIT = TimeUnit.SECONDS;
    private static final Duration COOLDOWN_TIME = Duration.ofSeconds(30L);
    private static final int COOLDOWN_CONCURRENCY_LEVEL = 4;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LockCleaner-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtExceptionLogger(UncaughtExceptionLogger.UELevel.INFO)).build();
    private final KeyColumnValueStore store;
    private final ExecutorService exec;
    private final TimestampProvider times;
    private final ConcurrentMap<KeyColumn, Instant> blocked;
    private final ConsistentKeyLockerSerializer serializer;
    private static final Logger log = LoggerFactory.getLogger(LockCleanerService.class);

    public StandardLockCleanerService(KeyColumnValueStore store, ConsistentKeyLockerSerializer serializer, ExecutorService exec, Duration cooldown, TimestampProvider times) {
        this.store = store;
        this.serializer = serializer;
        this.exec = exec;
        this.times = times;
        this.blocked = CacheBuilder.newBuilder().expireAfterWrite(cooldown.toNanos(), TimeUnit.NANOSECONDS).concurrencyLevel(4).build().asMap();
    }

    public StandardLockCleanerService(KeyColumnValueStore store, ConsistentKeyLockerSerializer serializer, TimestampProvider times) {
        this(store, serializer, StandardLockCleanerService.getDefaultExecutor(), COOLDOWN_TIME, times);
    }

    @Override
    public void clean(KeyColumn target, Instant cutoff, StoreTransaction tx) {
        Instant b = this.blocked.putIfAbsent(target, cutoff);
        if (null == b) {
            log.info("Enqueuing expired lock cleaner task for target={}, tx={}, cutoff={}", new Object[]{target, tx, cutoff});
            try {
                this.exec.submit(new StandardLockCleanerRunnable(this.store, target, tx, this.serializer, cutoff, this.times));
            }
            catch (RejectedExecutionException e) {
                log.debug("Failed to enqueue expired lock cleaner for target={}, tx={}, cutoff={}", new Object[]{target, tx, cutoff, e});
            }
        } else {
            log.debug("Blocked redundant attempt to enqueue lock cleaner task for target={}, tx={}, cutoff={}", new Object[]{target, tx, cutoff});
        }
    }

    private static ExecutorService getDefaultExecutor() {
        return new ThreadPoolExecutor(0, 1, 5L, KEEPALIVE_UNIT, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY);
    }
}

