/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.keycolumnvalue.ttl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.MetaAnnotatable;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.StoreMetaData;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KCVSManagerProxy;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StandardStoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.ttl.TTLKCVS;

public class TTLKCVSManager
extends KCVSManagerProxy {
    private final StoreFeatures features;
    private final Map<String, Integer> ttlEnabledStores = Maps.newConcurrentMap();

    public TTLKCVSManager(KeyColumnValueStoreManager manager) {
        super(manager);
        Preconditions.checkArgument((boolean)manager.getFeatures().hasCellTTL());
        Preconditions.checkArgument((!manager.getFeatures().hasStoreTTL() ? 1 : 0) != 0, (String)"Using TTLKCVSManager with %s is redundant: underlying implementation already supports store-level ttl", (Object[])new Object[]{manager});
        this.features = new StandardStoreFeatures.Builder(manager.getFeatures()).storeTTL(true).build();
    }

    public static boolean supportsAnyTTL(StoreFeatures features) {
        return features.hasCellTTL() || features.hasStoreTTL();
    }

    @Override
    public StoreFeatures getFeatures() {
        return this.features;
    }

    @Override
    public KeyColumnValueStore openDatabase(String name) throws BackendException {
        return this.openDatabase(name, StoreMetaData.EMPTY);
    }

    @Override
    public KeyColumnValueStore openDatabase(String name, StoreMetaData.Container metaData) throws BackendException {
        KeyColumnValueStore store = this.manager.openDatabase(name);
        int storeTTL = metaData.contains(StoreMetaData.TTL) ? (Integer)metaData.get(StoreMetaData.TTL) : -1;
        Preconditions.checkArgument((storeTTL > 0 ? 1 : 0) != 0, (String)"TTL must be positive: %s", (Object[])new Object[]{storeTTL});
        this.ttlEnabledStores.put(name, storeTTL);
        return new TTLKCVS(store, storeTTL);
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        if (!this.manager.getFeatures().hasStoreTTL()) {
            assert (this.manager.getFeatures().hasCellTTL());
            for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> sentry : mutations.entrySet()) {
                Integer ttl = this.ttlEnabledStores.get(sentry.getKey());
                if (null == ttl || 0 >= ttl) continue;
                for (KCVMutation mut : sentry.getValue().values()) {
                    if (!mut.hasAdditions()) continue;
                    TTLKCVSManager.applyTTL(mut.getAdditions(), ttl);
                }
            }
        }
        this.manager.mutateMany(mutations, txh);
    }

    public static void applyTTL(Collection<Entry> additions, int ttl) {
        for (Entry entry : additions) {
            assert (entry instanceof MetaAnnotatable);
            ((MetaAnnotatable)((Object)entry)).setMetaData(EntryMetaData.TTL, ttl);
        }
    }
}

