/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration.backend;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.util.time.Durations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsConfiguration
implements WriteConfiguration {
    private final Configuration config;
    private static final Logger log = LoggerFactory.getLogger(CommonsConfiguration.class);

    public CommonsConfiguration() {
        this((Configuration)new BaseConfiguration());
    }

    public CommonsConfiguration(Configuration config) {
        this.config = (Configuration)Preconditions.checkNotNull((Object)config);
    }

    public Configuration getCommonConfiguration() {
        return this.config;
    }

    @Override
    public <O> O get(String key, Class<O> dataType) {
        if (!this.config.containsKey(key)) {
            return null;
        }
        if (dataType.isArray()) {
            Preconditions.checkArgument((dataType.getComponentType() == String.class ? 1 : 0) != 0, (String)"Only string arrays are supported: %s", (Object[])new Object[]{dataType});
            return (O)this.config.getStringArray(key);
        }
        if (Number.class.isAssignableFrom(dataType)) {
            Object o = this.config.getProperty(key);
            if (dataType.isInstance(o)) {
                return (O)o;
            }
            return this.constructFromStringArgument(dataType, o.toString());
        }
        if (dataType == String.class) {
            return (O)this.config.getString(key);
        }
        if (dataType == Boolean.class) {
            return (O)Boolean.valueOf(this.config.getBoolean(key));
        }
        if (dataType.isEnum()) {
            Enum[] constants = (Enum[])dataType.getEnumConstants();
            Preconditions.checkState((null != constants && 0 < constants.length ? 1 : 0) != 0, (Object)"Zero-length or undefined enum");
            String enumString = this.config.getProperty(key).toString();
            for (Enum ec : constants) {
                if (!ec.toString().equals(enumString)) continue;
                return (O)ec;
            }
            throw new IllegalArgumentException("No match for string \"" + enumString + "\" in enum " + dataType);
        }
        if (dataType == Object.class) {
            return (O)this.config.getProperty(key);
        }
        if (Duration.class.isAssignableFrom(dataType)) {
            TemporalUnit unit;
            Object o = this.config.getProperty(key);
            if (o instanceof Duration) {
                return (O)o;
            }
            String[] comps = o.toString().split("\\s");
            switch (comps.length) {
                case 1: {
                    unit = ChronoUnit.MILLIS;
                    break;
                }
                case 2: {
                    unit = Durations.parse(comps[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot parse time duration from: " + o.toString());
                }
            }
            return (O)Duration.of(Long.valueOf(comps[0]), unit);
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType);
    }

    private <O> O constructFromStringArgument(Class<O> dataType, String arg) {
        try {
            Constructor<O> ctor = dataType.getConstructor(String.class);
            return ctor.newInstance(arg);
        }
        catch (Exception e) {
            log.error("Failed to parse configuration string \"{}\" into type {} due to the following reflection exception", new Object[]{arg, dataType, e});
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterable<String> getKeys(String prefix) {
        ArrayList result = Lists.newArrayList();
        Iterator keys = StringUtils.isNotBlank((String)prefix) ? this.config.getKeys(prefix) : this.config.getKeys();
        while (keys.hasNext()) {
            result.add(keys.next());
        }
        return result;
    }

    @Override
    public void close() {
    }

    @Override
    public <O> void set(String key, O value) {
        if (value == null) {
            this.config.clearProperty(key);
        } else if (Duration.class.isAssignableFrom(value.getClass())) {
            this.config.setProperty(key, (Object)((Duration)value).toMillis());
        } else {
            this.config.setProperty(key, value);
        }
    }

    @Override
    public void remove(String key) {
        this.config.clearProperty(key);
    }

    @Override
    public WriteConfiguration copy() {
        BaseConfiguration copy = new BaseConfiguration();
        copy.copy(this.config);
        return new CommonsConfiguration((Configuration)copy);
    }
}

