/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.schema.DefaultSchemaMaker;
import org.janusgraph.core.schema.EdgeLabelMaker;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.janusgraph.core.schema.SchemaManager;
import org.janusgraph.core.schema.VertexLabelMaker;
import org.janusgraph.graphdb.tinkerpop.JanusGraphDefaultSchemaMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSchemaMaker
implements DefaultSchemaMaker {
    private static final Logger log = LoggerFactory.getLogger(LoggingSchemaMaker.class);
    public static final DefaultSchemaMaker DEFAULT_INSTANCE = new LoggingSchemaMaker(JanusGraphDefaultSchemaMaker.INSTANCE);
    private final DefaultSchemaMaker proxy;

    public LoggingSchemaMaker(DefaultSchemaMaker proxy) {
        this.proxy = proxy;
    }

    @Override
    public Cardinality defaultPropertyCardinality(String key) {
        return this.proxy.defaultPropertyCardinality(key);
    }

    @Override
    public boolean ignoreUndefinedQueryTypes() {
        return this.proxy.ignoreUndefinedQueryTypes();
    }

    @Override
    public EdgeLabel makeEdgeLabel(EdgeLabelMaker factory) {
        log.warn("Edge Label with given name does not exist: {}", (Object)factory.getName());
        return this.proxy.makeEdgeLabel(factory);
    }

    @Override
    public PropertyKey makePropertyKey(PropertyKeyMaker factory) {
        log.warn("Property Key with given name does not exist: {}", (Object)factory.getName());
        return this.proxy.makePropertyKey(factory);
    }

    @Override
    public PropertyKey makePropertyKey(PropertyKeyMaker factory, Object value) {
        log.warn("Property Key with given name does not exist: {}", (Object)factory.getName());
        return this.proxy.makePropertyKey(factory, value);
    }

    @Override
    public VertexLabel makeVertexLabel(VertexLabelMaker factory) {
        log.warn("Vertex Label with given name does not exist: {}", (Object)factory.getName());
        return this.proxy.makeVertexLabel(factory);
    }

    @Override
    public void makePropertyConstraintForVertex(VertexLabel vertexLabel, PropertyKey key, SchemaManager manager) {
        log.warn("Property Key constraint does not exist for given Vertex Label {} and property key {}.", (Object)vertexLabel, (Object)key);
        this.proxy.makePropertyConstraintForVertex(vertexLabel, key, manager);
    }

    @Override
    public void makePropertyConstraintForEdge(EdgeLabel edgeLabel, PropertyKey key, SchemaManager manager) {
        log.warn("Property Key constraint does not exist for given Edge Label {} and property key {}.", (Object)edgeLabel, (Object)key);
        this.proxy.makePropertyConstraintForEdge(edgeLabel, key, manager);
    }

    @Override
    public void makeConnectionConstraint(EdgeLabel edgeLabel, VertexLabel outVLabel, VertexLabel inVLabel, SchemaManager manager) {
        log.warn("Connection constraint does not exist for given Edge Label {}, outgoing Vertex Label {} and incoming Vertex Label {}", new Object[]{edgeLabel, outVLabel, inVLabel});
        this.proxy.makeConnectionConstraint(edgeLabel, outVLabel, inVLabel, manager);
    }
}

