/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.maven.FileFilter;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.check.IViolationsOutput;
import org.jacoco.report.check.Rule;
import org.jacoco.report.check.RulesChecker;

final class ReportSupport {
    private final Log log;
    private final ExecFileLoader loader;
    private final List<IReportVisitor> formatters;

    public ReportSupport(Log log) {
        this.log = log;
        this.loader = new ExecFileLoader();
        this.formatters = new ArrayList<IReportVisitor>();
    }

    public void loadExecutionData(File execFile) throws IOException {
        this.log.info((CharSequence)("Loading execution data file " + execFile));
        this.loader.load(execFile);
    }

    public void addVisitor(IReportVisitor visitor) {
        this.formatters.add(visitor);
    }

    public void addRulesChecker(List<Rule> rules, IViolationsOutput output) {
        RulesChecker checker = new RulesChecker();
        checker.setRules(rules);
        this.formatters.add(checker.createVisitor(output));
    }

    public IReportVisitor initRootVisitor() throws IOException {
        MultiReportVisitor visitor = new MultiReportVisitor(this.formatters);
        visitor.visitInfo(this.loader.getSessionInfoStore().getInfos(), this.loader.getExecutionDataStore().getContents());
        return visitor;
    }

    public void processProject(IReportGroupVisitor visitor, MavenProject project, List<String> includes, List<String> excludes) throws IOException {
        this.processProject(visitor, project.getArtifactId(), project, includes, excludes, new NoSourceLocator());
    }

    public void processProject(IReportGroupVisitor visitor, String bundleName, MavenProject project, List<String> includes, List<String> excludes, String srcEncoding) throws IOException {
        this.processProject(visitor, bundleName, project, includes, excludes, new SourceFileCollection(project, srcEncoding));
    }

    private void processProject(IReportGroupVisitor visitor, String bundleName, MavenProject project, List<String> includes, List<String> excludes, ISourceFileLocator locator) throws IOException {
        CoverageBuilder builder = new CoverageBuilder();
        File classesDir = new File(project.getBuild().getOutputDirectory());
        if (classesDir.isDirectory()) {
            Analyzer analyzer = new Analyzer(this.loader.getExecutionDataStore(), (ICoverageVisitor)builder);
            FileFilter filter = new FileFilter(includes, excludes);
            for (File file : filter.getFiles(classesDir)) {
                analyzer.analyzeAll(file);
            }
        }
        IBundleCoverage bundle = builder.getBundle(bundleName);
        this.logBundleInfo(bundle, builder.getNoMatchClasses());
        visitor.visitBundle(bundle, locator);
    }

    private void logBundleInfo(IBundleCoverage bundle, Collection<IClassCoverage> nomatch) {
        this.log.info((CharSequence)String.format("Analyzed bundle '%s' with %s classes", bundle.getName(), bundle.getClassCounter().getTotalCount()));
        if (!nomatch.isEmpty()) {
            this.log.warn((CharSequence)String.format("Classes in bundle '%s' do not match with execution data. For report generation the same class files must be used as at runtime.", bundle.getName()));
            for (IClassCoverage c : nomatch) {
                this.log.warn((CharSequence)String.format("Execution data for class %s does not match.", c.getName()));
            }
        }
        if (bundle.containsCode() && bundle.getLineCounter().getTotalCount() == 0) {
            this.log.warn((CharSequence)"To enable source code annotation class files have to be compiled with debug information.");
        }
    }

    private static List<File> getCompileSourceRoots(MavenProject project) {
        ArrayList<File> result = new ArrayList<File>();
        for (Object path : project.getCompileSourceRoots()) {
            result.add(ReportSupport.resolvePath(project, (String)path));
        }
        return result;
    }

    private static File resolvePath(MavenProject project, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(project.getBasedir(), path);
        }
        return file;
    }

    private static class NoSourceLocator
    implements ISourceFileLocator {
        private NoSourceLocator() {
        }

        public Reader getSourceFile(String packageName, String fileName) {
            return null;
        }

        public int getTabWidth() {
            return 0;
        }
    }

    private static class SourceFileCollection
    implements ISourceFileLocator {
        private final List<File> sourceRoots;
        private final String encoding;

        public SourceFileCollection(MavenProject project, String encoding) {
            this.sourceRoots = ReportSupport.getCompileSourceRoots(project);
            this.encoding = encoding;
        }

        public Reader getSourceFile(String packageName, String fileName) throws IOException {
            String r = packageName.length() > 0 ? packageName + '/' + fileName : fileName;
            for (File sourceRoot : this.sourceRoots) {
                File file = new File(sourceRoot, r);
                if (!file.exists() || !file.isFile()) continue;
                return new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
            }
            return null;
        }

        public int getTabWidth() {
            return 4;
        }
    }
}

