/*
 * Decompiled with CFR 0.152.
 */
package org.isomorphism.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;
import org.isomorphism.util.FixedIntervalRefillStrategy;
import org.isomorphism.util.TokenBucket;
import org.isomorphism.util.TokenBucketImpl;

public final class TokenBuckets {
    private static final TokenBucket.SleepStrategy YIELDING_SLEEP_STRATEGY = new TokenBucket.SleepStrategy(){

        public void sleep() {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.NANOSECONDS);
        }
    };
    private static final TokenBucket.SleepStrategy BUSY_WAIT_SLEEP_STRATEGY = new TokenBucket.SleepStrategy(){

        public void sleep() {
        }
    };

    private TokenBuckets() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long capacity = null;
        private TokenBucket.RefillStrategy refillStrategy = null;
        private TokenBucket.SleepStrategy sleepStrategy = TokenBuckets.access$000();
        private final Ticker ticker = Ticker.systemTicker();

        public Builder withCapacity(long numTokens) {
            Preconditions.checkArgument((numTokens > 0L ? 1 : 0) != 0, (Object)"Must specify a positive number of tokens");
            this.capacity = numTokens;
            return this;
        }

        public Builder withFixedIntervalRefillStrategy(long refillTokens, long period, TimeUnit unit) {
            return this.withRefillStrategy(new FixedIntervalRefillStrategy(this.ticker, refillTokens, period, unit));
        }

        public Builder withRefillStrategy(TokenBucket.RefillStrategy refillStrategy) {
            this.refillStrategy = (TokenBucket.RefillStrategy)Preconditions.checkNotNull((Object)refillStrategy);
            return this;
        }

        public Builder withYieldingSleepStrategy() {
            return this.withSleepStrategy(YIELDING_SLEEP_STRATEGY);
        }

        public Builder withBusyWaitSleepStrategy() {
            return this.withSleepStrategy(BUSY_WAIT_SLEEP_STRATEGY);
        }

        public Builder withSleepStrategy(TokenBucket.SleepStrategy sleepStrategy) {
            this.sleepStrategy = (TokenBucket.SleepStrategy)Preconditions.checkNotNull((Object)sleepStrategy);
            return this;
        }

        public TokenBucketImpl build() {
            Preconditions.checkNotNull((Object)this.capacity, (Object)"Must specify a capacity");
            Preconditions.checkNotNull((Object)this.refillStrategy, (Object)"Must specify a refill strategy");
            return new TokenBucketImpl(this.capacity, this.refillStrategy, this.sleepStrategy);
        }
    }
}

