/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.service.factory.soap;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import org.irenical.fetchy.service.factory.soap.ServiceClientFilter;
import org.irenical.fetchy.service.factory.soap.ServiceClientPortFilter;
import org.irenical.fetchy.service.factory.soap.ServiceConfigException;
import org.irenical.jindy.Config;
import org.irenical.jindy.ConfigFactory;
import org.irenical.jindy.ConfigNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceClient<ENDPOINT extends Service, PORT> {
    private final Logger LOG = LoggerFactory.getLogger(ServiceClient.class);
    public static final String DEFAULT_FILTER_PACKAGE = "org.irenical.fetchy.service.factory.soap.";
    private final Class<ENDPOINT> endpointClass;
    private final Class<PORT> portClass;
    private Context jndiContext = null;
    private URI soapURI = null;
    private ENDPOINT endpointSOAPService;
    private List<Handler> handlers = new LinkedList<Handler>();
    private List<WebServiceFeature> webServiceFeatureList = new LinkedList<WebServiceFeature>();
    private List<ServiceClientFilter> serviceClientFilters = new LinkedList<ServiceClientFilter>();
    private HandlerResolver handlerResolver = paramPortInfo -> this.handlers;

    public ServiceClient(Class<ENDPOINT> endpointClass, Class<PORT> portClass, URI soapURL, ServiceClientFilter ... filters) {
        this.endpointClass = endpointClass;
        this.portClass = portClass;
        this.soapURI = soapURL;
        if (filters != null) {
            this.serviceClientFilters = Arrays.asList(filters);
        }
        this.initEndpoint();
    }

    public ServiceClient(Class<ENDPOINT> endpointClass, Class<PORT> portClass, String soapURLProperty, String filtersProperty, ServiceClientFilter ... filters) {
        String soapURL;
        this.endpointClass = endpointClass;
        this.portClass = portClass;
        Config configs = ConfigFactory.getConfig();
        try {
            soapURL = configs.getMandatoryString(soapURLProperty);
        }
        catch (ConfigNotFoundException cnfe) {
            throw new ServiceConfigException("SoapURL config not found.", cnfe);
        }
        try {
            String filterConfigs = configs.getMandatoryString(filtersProperty);
            this.initFiltersFromProperties(filterConfigs);
        }
        catch (ConfigNotFoundException e) {
            this.LOG.info("Service Filters config property not found: " + filtersProperty + ". Using fallback filters");
            if (filters != null) {
                this.serviceClientFilters = Arrays.asList(filters);
            }
            this.LOG.info("Service fallback filters not found");
        }
        this.initEndpoint(soapURL);
    }

    private void initFiltersFromJNDI() {
        this.initFiltersFromProperties(null);
    }

    private void initFiltersFromProperties(String filterList) {
        if (filterList == null) {
            try {
                if (this.jndiContext == null) {
                    this.LOG.info("No JNDI context for searching filters");
                    return;
                }
                filterList = (String)this.jndiContext.lookup("filters");
            }
            catch (NamingException e) {
                this.LOG.info("No client service filter list found in JNDI context /filters for service with endpoint " + this.endpointClass.getName());
                return;
            }
        }
        for (String filterClassName : filterList.split(",")) {
            Class<?> clazz;
            if (filterClassName.isEmpty()) continue;
            if (!filterClassName.contains(".")) {
                filterClassName = DEFAULT_FILTER_PACKAGE + filterClassName.trim();
            }
            try {
                clazz = Class.forName(filterClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class name " + filterClassName + " given in /filters not found", e);
            }
            if (!ServiceClientFilter.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Given class " + clazz.getName() + " in /filters, but class doesn't extend ServiceClientFilter");
            }
            Class<?> scfClass = clazz;
            try {
                ServiceClientFilter filter;
                Constructor<?> constructor;
                if (this.jndiContext != null) {
                    constructor = scfClass.getConstructor(Context.class);
                    filter = (ServiceClientFilter)constructor.newInstance(this.jndiContext);
                    this.serviceClientFilters.add(filter);
                } else {
                    constructor = scfClass.getConstructor(new Class[0]);
                    filter = (ServiceClientFilter)constructor.newInstance(new Object[0]);
                }
                this.serviceClientFilters.add(filter);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error initializing " + filterClassName + ": (given in /filters)", e);
            }
        }
    }

    private void initEndpoint() {
        this.initEndpoint(null);
    }

    private void initEndpoint(String serviceURL) {
        try {
            URL soapURL = this.soapURI != null ? this.soapURI.toURL() : new URL(serviceURL);
            this.endpointSOAPService = (Service)this.endpointClass.getConstructor(URL.class).newInstance(soapURL);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating a new instance of SOAP endpoint: " + this.endpointClass.getName(), e);
        }
        for (ServiceClientFilter filter : this.serviceClientFilters) {
            filter.init(this);
            this.LOG.info("Loaded service client filter " + filter.getClass().getName());
        }
        if (!this.handlers.isEmpty()) {
            this.setSOAPHandlers();
        }
    }

    private void setSOAPHandlers() {
        this.endpointSOAPService.setHandlerResolver(this.handlerResolver);
    }

    public void addSOAPHandler(Handler handler) {
        this.handlers.add(handler);
        this.setSOAPHandlers();
    }

    public void addSOAPFeature(WebServiceFeature feature) {
        this.webServiceFeatureList.add(feature);
    }

    public ENDPOINT getEndpoint() {
        return this.endpointSOAPService;
    }

    public PORT getPort(ServiceClientPortFilter ... portFilters) {
        Object port = this.getEndpoint().getPort(this.portClass, this.webServiceFeatureList.toArray(new WebServiceFeature[this.webServiceFeatureList.size()]));
        for (ServiceClientFilter filter : this.serviceClientFilters) {
            filter.postGetPort(this, port);
        }
        if (portFilters != null) {
            for (ServiceClientPortFilter portFilter : portFilters) {
                portFilter.postGetPort(port);
            }
        }
        return (PORT)port;
    }

    public PORT getPort() {
        return this.getPort(null);
    }
}

