/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.fetchy.service.factory.soap;

import java.net.URI;
import javax.xml.ws.Service;
import org.irenical.fetchy.node.ServiceNode;
import org.irenical.fetchy.service.factory.ServiceDiscoveryExecutor;
import org.irenical.fetchy.service.factory.soap.ServiceClient;
import org.irenical.fetchy.service.factory.soap.ServiceClientFilter;

public class SOAPServiceExecutor<PORT, ENDPOINT extends Service>
extends ServiceDiscoveryExecutor<PORT, PORT> {
    private final Class<PORT> portClass;
    private final Class<ENDPOINT> endpointClass;
    private String address;
    private PORT port;

    public SOAPServiceExecutor(Class<PORT> portClass, Class<ENDPOINT> endpointClass, String serviceId) {
        super(serviceId);
        this.portClass = portClass;
        this.endpointClass = endpointClass;
    }

    protected PORT newInstance(ServiceNode serviceNode) throws Exception {
        if (this.address == null || !serviceNode.getAddress().equals(this.address) || this.port == null) {
            this.address = serviceNode.getAddress();
            ServiceClient<ENDPOINT, PORT> serviceClient = new ServiceClient<ENDPOINT, PORT>(this.endpointClass, this.portClass, URI.create(serviceNode.getAddress()), new ServiceClientFilter[0]);
            this.port = serviceClient.getPort();
        }
        return this.port;
    }

    protected void onBeforeExecute(PORT port) {
    }

    protected void onAfterExecute(PORT port) {
    }
}

