/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.List;
import org.instancio.documentation.InternalApi;
import org.instancio.internal.selectors.ScopelessSelector;
import org.instancio.internal.spi.InternalServiceProvider;
import org.instancio.internal.util.Fail;

@InternalApi
public interface Target {
    public Class<?> getTargetClass();

    default public ScopelessSelector toScopelessSelector() {
        throw Fail.withFataInternalError("Unhandled selector target: %s", this.getTargetClass());
    }

    default public Target withRootClass(TargetContext targetContext) {
        return this;
    }

    public static class TargetContext {
        private final Class<?> rootClass;
        private final List<InternalServiceProvider> internalServiceProviders;

        TargetContext(Class<?> rootClass, List<InternalServiceProvider> internalServiceProviders) {
            this.rootClass = rootClass;
            this.internalServiceProviders = internalServiceProviders;
        }

        Class<?> getRootClass() {
            return this.rootClass;
        }

        List<InternalServiceProvider> getInternalServiceProviders() {
            return this.internalServiceProviders;
        }
    }
}

