/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.Collections;
import java.util.List;
import org.instancio.Scope;
import org.instancio.TargetSelector;
import org.instancio.internal.ApiMethodSelector;
import org.instancio.internal.selectors.InternalSelector;
import org.instancio.internal.selectors.UnusedSelectorDescription;
import org.instancio.internal.util.Format;
import org.jetbrains.annotations.NotNull;

abstract class BaseSelector
implements UnusedSelectorDescription,
InternalSelector {
    private final ApiMethodSelector apiMethodSelector;
    private final List<Scope> scopes;
    private final Throwable stackTraceHolder;
    private final boolean isLenient;
    private final boolean isHiddenFromVerboseOutput;

    BaseSelector(ApiMethodSelector apiMethodSelector, List<Scope> scopes, Throwable stackTraceHolder, boolean isLenient, boolean isHiddenFromVerboseOutput) {
        this.apiMethodSelector = apiMethodSelector;
        this.scopes = Collections.unmodifiableList(scopes);
        this.stackTraceHolder = stackTraceHolder;
        this.isLenient = isLenient;
        this.isHiddenFromVerboseOutput = isHiddenFromVerboseOutput;
    }

    @Override
    public ApiMethodSelector getApiMethodSelector() {
        return this.apiMethodSelector;
    }

    @Override
    @NotNull
    public final List<Scope> getScopes() {
        return this.scopes;
    }

    @Override
    public final List<TargetSelector> flatten() {
        return Collections.singletonList(this);
    }

    @Override
    public final boolean isLenient() {
        return this.isLenient;
    }

    @Override
    public final boolean isHiddenFromVerboseOutput() {
        return this.isHiddenFromVerboseOutput;
    }

    @Override
    public final String getDescription() {
        return String.format("%s%n    at %s", this, Format.firstNonInstancioStackTraceLine(this.getStackTraceHolder()));
    }

    public final Throwable getStackTraceHolder() {
        return this.stackTraceHolder;
    }
}

