/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.instancio.internal.util.Format;

public final class ParameterizedTypeImpl
implements ParameterizedType {
    private final Type ownerType;
    private final Class<?> rawType;
    private final Type[] typeArguments;

    private ParameterizedTypeImpl(Type ownerType, Class<?> rawType, Type ... typeArguments) {
        this.ownerType = ownerType;
        this.rawType = rawType;
        this.typeArguments = typeArguments;
    }

    public ParameterizedTypeImpl(Class<?> rawType, Type ... typeArguments) {
        this((Type)null, rawType, typeArguments);
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.typeArguments.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterizedTypeImpl)) {
            return false;
        }
        ParameterizedTypeImpl that = (ParameterizedTypeImpl)o;
        return Objects.equals(this.ownerType, that.ownerType) && Objects.equals(this.rawType, that.rawType) && Arrays.equals(this.typeArguments, that.typeArguments);
    }

    public int hashCode() {
        int result = this.ownerType != null ? this.ownerType.hashCode() : 0;
        result = 31 * result + (this.rawType != null ? this.rawType.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.typeArguments);
        return result;
    }

    public String toString() {
        String args = Stream.of(this.typeArguments).map(Format::withoutPackage).collect(Collectors.joining(", "));
        return Format.withoutPackage(this.rawType) + "<" + args + ">";
    }
}

