/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.instancio.TargetSelector;
import org.instancio.internal.assignment.AssignmentErrorUtil;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Fail;

class OriginSelectorValidator {
    private final ModelContext modelContext;
    private final Map<TargetSelector, InternalNode> seen = new HashMap<TargetSelector, InternalNode>();

    OriginSelectorValidator(ModelContext modelContext) {
        this.modelContext = modelContext;
    }

    void checkNode(InternalNode node) {
        if (node.isIgnored()) {
            return;
        }
        Set<TargetSelector> originSelectors = this.modelContext.getAssignmentOriginSelectors(node);
        for (TargetSelector selector : originSelectors) {
            InternalNode prevSeen = this.seen.put(selector, node);
            if (prevSeen == null) continue;
            throw Fail.withUnresolvedAssignment(AssignmentErrorUtil.getAmbiguousErrorMessage(selector, prevSeen, node), new Object[0]);
        }
    }
}

