/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generators;

import java.util.Collection;
import org.instancio.documentation.InternalApi;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.ArrayGeneratorSpec;
import org.instancio.generator.specs.BooleanSpec;
import org.instancio.generator.specs.ByteSpec;
import org.instancio.generator.specs.CharacterSpec;
import org.instancio.generator.specs.CollectionGeneratorSpec;
import org.instancio.generator.specs.DoubleSpec;
import org.instancio.generator.specs.EmitGeneratorSpec;
import org.instancio.generator.specs.EnumSetGeneratorSpec;
import org.instancio.generator.specs.EnumSpec;
import org.instancio.generator.specs.FloatSpec;
import org.instancio.generator.specs.HashSpec;
import org.instancio.generator.specs.IntegerSpec;
import org.instancio.generator.specs.IntervalSpec;
import org.instancio.generator.specs.LongSpec;
import org.instancio.generator.specs.MapGeneratorSpec;
import org.instancio.generator.specs.NumericSequenceSpec;
import org.instancio.generator.specs.OptionalGeneratorSpec;
import org.instancio.generator.specs.ShortSpec;
import org.instancio.generator.specs.ShuffleSpec;
import org.instancio.generator.specs.StringSpec;
import org.instancio.generator.specs.UUIDSpec;
import org.instancio.generators.AtomicGenerators;
import org.instancio.generators.ChecksumSpecs;
import org.instancio.generators.FinanceSpecs;
import org.instancio.generators.Generators;
import org.instancio.generators.IdSpecs;
import org.instancio.generators.IoSpecs;
import org.instancio.generators.MathSpecs;
import org.instancio.generators.NetSpecs;
import org.instancio.generators.NioSpecs;
import org.instancio.generators.SpatialSpecs;
import org.instancio.generators.TemporalSpecs;
import org.instancio.generators.TextSpecs;
import org.instancio.generators.ValueSpecs;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.array.OneOfArrayGenerator;
import org.instancio.internal.generator.domain.hash.HashGenerator;
import org.instancio.internal.generator.lang.BooleanGenerator;
import org.instancio.internal.generator.lang.ByteGenerator;
import org.instancio.internal.generator.lang.CharacterGenerator;
import org.instancio.internal.generator.lang.DoubleGenerator;
import org.instancio.internal.generator.lang.EnumGenerator;
import org.instancio.internal.generator.lang.FloatGenerator;
import org.instancio.internal.generator.lang.IntegerGenerator;
import org.instancio.internal.generator.lang.LongGenerator;
import org.instancio.internal.generator.lang.ShortGenerator;
import org.instancio.internal.generator.lang.StringGenerator;
import org.instancio.internal.generator.misc.EmitGenerator;
import org.instancio.internal.generator.misc.IntervalGenerator;
import org.instancio.internal.generator.sequence.IntegerSequenceGenerator;
import org.instancio.internal.generator.sequence.LongSequenceGenerator;
import org.instancio.internal.generator.shuffle.ShuffleGenerator;
import org.instancio.internal.generator.util.CollectionGeneratorSpecImpl;
import org.instancio.internal.generator.util.EnumSetGenerator;
import org.instancio.internal.generator.util.MapGeneratorSpecImpl;
import org.instancio.internal.generator.util.OneOfCollectionGenerator;
import org.instancio.internal.generator.util.OptionalGenerator;
import org.instancio.internal.generator.util.UUIDGenerator;
import org.instancio.internal.generators.AtomicSpecsImpl;
import org.instancio.internal.generators.ChecksumSpecsImpl;
import org.instancio.internal.generators.FinanceSpecsImpl;
import org.instancio.internal.generators.IdSpecsImpl;
import org.instancio.internal.generators.IoSpecsImpl;
import org.instancio.internal.generators.MathSpecsImpl;
import org.instancio.internal.generators.NetSpecsImpl;
import org.instancio.internal.generators.NioSpecsImpl;
import org.instancio.internal.generators.SpatialSpecsImpl;
import org.instancio.internal.generators.TemporalSpecsImpl;
import org.instancio.internal.generators.TextSpecsImpl;

@InternalApi
public final class BuiltInGenerators
implements Generators,
ValueSpecs {
    private final GeneratorContext context;

    public BuiltInGenerators(GeneratorContext context) {
        this.context = context;
    }

    @Override
    public StringSpec string() {
        return new StringGenerator(this.context);
    }

    @Override
    public BooleanSpec booleans() {
        return new BooleanGenerator(this.context);
    }

    @Override
    public CharacterSpec chars() {
        return new CharacterGenerator(this.context);
    }

    @Override
    public ByteSpec bytes() {
        return new ByteGenerator(this.context);
    }

    @Override
    public ShortSpec shorts() {
        return new ShortGenerator(this.context);
    }

    @Override
    public IntegerSpec ints() {
        return new IntegerGenerator(this.context);
    }

    @Override
    public NumericSequenceSpec<Integer> intSeq() {
        return new IntegerSequenceGenerator(this.context);
    }

    @Override
    public LongSpec longs() {
        return new LongGenerator(this.context);
    }

    @Override
    public NumericSequenceSpec<Long> longSeq() {
        return new LongSequenceGenerator(this.context);
    }

    @Override
    public FloatSpec floats() {
        return new FloatGenerator(this.context);
    }

    @Override
    public DoubleSpec doubles() {
        return new DoubleGenerator(this.context);
    }

    @Override
    public <E extends Enum<E>> EnumSpec<E> enumOf(Class<E> enumClass) {
        return new EnumGenerator<E>(this.context, enumClass);
    }

    @Override
    public MathSpecs math() {
        return new MathSpecsImpl(this.context);
    }

    @Override
    public NetSpecs net() {
        return new NetSpecsImpl(this.context);
    }

    @SafeVarargs
    public final <T> OneOfArrayGenerator<T> oneOf(T ... choices) {
        return new OneOfArrayGenerator(this.context).oneOf((Object[])choices);
    }

    public <T> OneOfCollectionGenerator<T> oneOf(Collection<T> choices) {
        return new OneOfCollectionGenerator(this.context).oneOf((Collection)choices);
    }

    @Override
    @SafeVarargs
    public final <T> ShuffleSpec<T> shuffle(T ... array) {
        return new ShuffleGenerator(this.context).shuffle((Object[])array);
    }

    @Override
    public <T> ShuffleSpec<T> shuffle(Collection<T> collection) {
        return new ShuffleGenerator(this.context).shuffle((Collection)collection);
    }

    @Override
    public <T> OptionalGeneratorSpec<T> optional() {
        return new OptionalGenerator(this.context);
    }

    @Override
    public <T> ArrayGeneratorSpec<T> array() {
        return new ArrayGenerator(this.context);
    }

    @Override
    public <T> CollectionGeneratorSpec<T> collection() {
        return new CollectionGeneratorSpecImpl(this.context);
    }

    @Override
    public <E extends Enum<E>> EnumSetGeneratorSpec<E> enumSet(Class<E> enumClass) {
        return new EnumSetGenerator<E>(this.context, enumClass);
    }

    @Override
    public <K, V> MapGeneratorSpec<K, V> map() {
        return new MapGeneratorSpecImpl(this.context);
    }

    @Override
    public <T> EmitGeneratorSpec<T> emit() {
        return new EmitGenerator(this.context);
    }

    @Override
    public <T> IntervalSpec<T> intervalStarting(T startingValue) {
        return new IntervalGenerator<T>(this.context, startingValue);
    }

    @Override
    public AtomicGenerators atomic() {
        return new AtomicSpecsImpl(this.context);
    }

    @Override
    public ChecksumSpecs checksum() {
        return new ChecksumSpecsImpl(this.context);
    }

    @Override
    public IoSpecs io() {
        return new IoSpecsImpl(this.context);
    }

    @Override
    public NioSpecs nio() {
        return new NioSpecsImpl(this.context);
    }

    @Override
    public TemporalSpecs temporal() {
        return new TemporalSpecsImpl(this.context);
    }

    @Override
    public TextSpecs text() {
        return new TextSpecsImpl(this.context);
    }

    @Override
    public IdSpecs id() {
        return new IdSpecsImpl(this.context);
    }

    @Override
    public HashSpec hash() {
        return new HashGenerator(this.context);
    }

    @Override
    public FinanceSpecs finance() {
        return new FinanceSpecsImpl(this.context);
    }

    @Override
    public SpatialSpecs spatial() {
        return new SpatialSpecsImpl(this.context);
    }

    @Override
    public UUIDSpec uuid() {
        return new UUIDGenerator(this.context);
    }
}

