/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.text;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.WordSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;

public class WordGenerator
extends AbstractGenerator<String>
implements WordSpec {
    private static final Map<WordClass, List<String>> CACHE = new EnumMap<WordClass, List<String>>(WordClass.class);
    private WordClass wordClass;

    public WordGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "word()";
    }

    @Override
    public WordGenerator adjective() {
        return this.wordClass(WordClass.ADJECTIVE);
    }

    @Override
    public WordGenerator adverb() {
        return this.wordClass(WordClass.ADVERB);
    }

    @Override
    public WordGenerator noun() {
        return this.wordClass(WordClass.NOUN);
    }

    @Override
    public WordGenerator verb() {
        return this.wordClass(WordClass.VERB);
    }

    WordGenerator wordClass(WordClass wordClass) {
        this.wordClass = wordClass;
        return this;
    }

    @Override
    public WordGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        WordClass wc = ObjectUtils.defaultIfNull(this.wordClass, () -> random.oneOf(WordClass.values()));
        return this.getWord(random, wc);
    }

    private String getWord(Random random, WordClass wordClass) {
        List<String> words = this.getWords(wordClass);
        return random.oneOf(words);
    }

    private List<String> getWords(WordClass wordClass) {
        List<String> words = CACHE.get((Object)wordClass);
        if (words == null) {
            words = WordGenerator.load(wordClass.file);
            CACHE.put(wordClass, words);
        }
        return words;
    }

    private static List<String> load(String file) {
        ArrayList<String> results = new ArrayList<String>(3000);
        try {
            InputStream in = WordGenerator.class.getResourceAsStream(file);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String line;
                while ((line = reader.readLine()) != null) {
                    results.add(line);
                }
            }
        }
        catch (Exception ex) {
            throw Fail.withInternalError("Error loading input stream", ex);
        }
        return results;
    }

    static enum WordClass {
        ADJECTIVE("adjective", "/adjectives.txt"),
        ADVERB("adverb", "/adverbs.txt"),
        NOUN("noun", "/nouns.txt"),
        VERB("verb", "/verbs.txt");

        private final String key;
        private final String file;

        private WordClass(String key, String file) {
            this.key = key;
            this.file = file;
        }

        static WordClass getByKey(String k) {
            for (WordClass wc : WordClass.values()) {
                if (!k.equals(wc.key)) continue;
                return wc;
            }
            return null;
        }
    }
}

