/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.sql;

import java.sql.Timestamp;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.TemporalSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.time.InstantGenerator;

public class TimestampGenerator
extends AbstractGenerator<Timestamp>
implements TemporalSpec<Timestamp> {
    private final InstantGenerator delegate;

    public TimestampGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new InstantGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "timestamp()";
    }

    @Override
    public TimestampGenerator past() {
        this.delegate.past();
        return this;
    }

    @Override
    public TimestampGenerator future() {
        this.delegate.future();
        return this;
    }

    public TimestampGenerator min(Timestamp min) {
        this.delegate.min(min.toInstant());
        return this;
    }

    public TimestampGenerator max(Timestamp max) {
        this.delegate.max(max.toInstant());
        return this;
    }

    public TimestampGenerator range(Timestamp min, Timestamp max) {
        this.delegate.range(min.toInstant(), max.toInstant());
        return this;
    }

    @Override
    public TimestampGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    public Timestamp tryGenerateNonNull(Random random) {
        return Timestamp.from(this.delegate.tryGenerateNonNull(random));
    }
}

