/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.sql;

import java.sql.Date;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.TemporalSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.time.LocalDateGenerator;

public class SqlDateGenerator
extends AbstractGenerator<Date>
implements TemporalSpec<Date> {
    private final LocalDateGenerator delegate;

    public SqlDateGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new LocalDateGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "sqlDate()";
    }

    @Override
    public SqlDateGenerator past() {
        this.delegate.past();
        return this;
    }

    @Override
    public SqlDateGenerator future() {
        this.delegate.future();
        return this;
    }

    public SqlDateGenerator min(Date min) {
        this.delegate.min(min.toLocalDate());
        return this;
    }

    public SqlDateGenerator max(Date max) {
        this.delegate.max(max.toLocalDate());
        return this;
    }

    public SqlDateGenerator range(Date min, Date max) {
        this.delegate.range(min.toLocalDate(), max.toLocalDate());
        return this;
    }

    @Override
    public SqlDateGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    public Date tryGenerateNonNull(Random random) {
        return Date.valueOf(this.delegate.tryGenerateNonNull(random));
    }
}

