/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.id.can;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.can.SinSpec;
import org.instancio.internal.generator.checksum.LuhnGenerator;

public class SinGenerator
extends LuhnGenerator
implements SinSpec {
    private static final int SIN_LENGTH = 9;
    private Type type;
    private String separator;

    public SinGenerator(GeneratorContext context) {
        super(context);
        this.length(9);
    }

    @Override
    public String apiMethod() {
        return "sin()";
    }

    @Override
    public SinGenerator permanent() {
        this.type = Type.PERMANENT;
        return this;
    }

    @Override
    public SinGenerator temporary() {
        this.type = Type.TEMPORARY;
        return this;
    }

    @Override
    public SinGenerator separator(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    public SinGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        String sin = super.tryGenerateNonNull(random);
        if (this.separator == null) {
            return sin;
        }
        return sin.substring(0, 3) + this.separator + sin.substring(3, 6) + this.separator + sin.substring(6, 9);
    }

    @Override
    protected String payload(Random random) {
        int length = this.payloadLength();
        char[] res = new char[length];
        res[0] = this.getFirstDigit(random);
        for (int i = 1; i < length; ++i) {
            res[i] = random.characterRange('0', '9');
        }
        return new String(res);
    }

    private char getFirstDigit(Random random) {
        int tempFirstDigit = 57;
        if (this.type == Type.TEMPORARY) {
            return '9';
        }
        char permFirstDigit = random.characterRange('1', '7');
        if (this.type == Type.PERMANENT) {
            return permFirstDigit;
        }
        return random.trueOrFalse() ? (char)'9' : (char)permFirstDigit;
    }

    private static enum Type {
        PERMANENT,
        TEMPORARY;

    }
}

