/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.checksum;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.NumberUtils;

public abstract class BaseModCheckGenerator
extends AbstractGenerator<String> {
    protected BaseModCheckGenerator(GeneratorContext context) {
        super(context);
    }

    protected abstract int payloadLength();

    @Override
    protected String tryGenerateNonNull(Random random) {
        String prefix = random.digits(this.prefixLength());
        String payload = this.payload(random);
        char checkDigit = this.getCheckDigit(payload);
        String suffix = random.digits(this.suffixLength());
        StringBuilder result = new StringBuilder(prefix).append(payload).append(suffix);
        result.setCharAt(this.checkPosition(), checkDigit);
        return result.toString();
    }

    protected String payload(Random random) {
        int length = this.payloadLength();
        char[] res = new char[length];
        res[0] = random.characterRange('1', '9');
        for (int i = 1; i < length; ++i) {
            res[i] = random.characterRange('0', '9');
        }
        return new String(res);
    }

    protected char getCheckDigit(String payload) {
        int result = this.base() - this.modulo(payload);
        if (result == 10) {
            return this.treat10As();
        }
        if (result == 11) {
            return this.treat11As();
        }
        return (char)(result + 48);
    }

    protected int modulo(String payload) {
        String newPayload = this.direction() == Direction.RIGHT_TO_LEFT ? new StringBuilder(payload).reverse().toString() : payload;
        int sum = 0;
        int bound = payload.length();
        for (int i = 0; i < bound; ++i) {
            int n = this.extractDigit(i, newPayload);
            if (this.sumDigits()) {
                n = NumberUtils.sumDigits(n);
                n = NumberUtils.sumDigits(n);
            }
            sum += n;
        }
        return sum % this.base();
    }

    private int extractDigit(int position, String string) {
        int digit = string.charAt(position) - 48;
        return position % 2 == 0 ? digit * this.even(position) : digit * this.odd(position);
    }

    protected int prefixLength() {
        return 0;
    }

    protected int suffixLength() {
        return 1;
    }

    protected int checkPosition() {
        return this.prefixLength() + this.payloadLength();
    }

    protected int even(int position) {
        return 2;
    }

    protected int odd(int position) {
        return 1;
    }

    protected boolean sumDigits() {
        return true;
    }

    protected Direction direction() {
        return Direction.RIGHT_TO_LEFT;
    }

    protected int base() {
        return 10;
    }

    protected char treat10As() {
        return '0';
    }

    protected char treat11As() {
        return '0';
    }

    static enum Direction {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }
}

