/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.array;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.specs.OneOfArrayGeneratorSpec;
import org.instancio.generator.specs.OneOfArraySpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.InternalGeneratorHint;

public class OneOfArrayGenerator<T>
extends AbstractGenerator<T>
implements OneOfArrayGeneratorSpec<T>,
OneOfArraySpec<T> {
    private static final Hints ALLOW_EMPTY_HINT = Hints.builder().with(InternalGeneratorHint.builder().emptyResult(true).build()).build();
    private T[] values;
    private boolean allowRandomValues;

    public OneOfArrayGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "oneOf()";
    }

    @Override
    @SafeVarargs
    public final OneOfArrayGenerator<T> oneOf(T ... values) {
        this.values = ApiValidator.notEmpty(values, "Array must have at least one element", new Object[0]);
        return this;
    }

    @Override
    public OneOfArrayGenerator<T> orRandom() {
        this.allowRandomValues = true;
        return this;
    }

    @Override
    public OneOfArrayGenerator<T> nullable() {
        super.nullable();
        return this;
    }

    @Override
    public T tryGenerateNonNull(Random random) {
        return random.oneOf(this.values);
    }

    @Override
    public Hints hints() {
        return this.getContext().random().diceRoll(this.allowRandomValues) ? ALLOW_EMPTY_HINT : super.hints();
    }
}

