/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import org.instancio.generator.Generator;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.GeneratedValuePostProcessor;
import org.instancio.internal.generation.NodeHandler;
import org.instancio.internal.generation.StringPrefixingPostProcessor;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.settings.Keys;
import org.jetbrains.annotations.NotNull;

class UsingGeneratorResolverHandler
implements NodeHandler {
    private final ModelContext context;
    private final GeneratorResolver generatorResolver;
    private final GeneratedValuePostProcessor stringPostProcessor;

    UsingGeneratorResolverHandler(ModelContext context, GeneratorResolver generatorResolver) {
        this.context = context;
        this.generatorResolver = generatorResolver;
        this.stringPostProcessor = new StringPrefixingPostProcessor(context.getSettings().get(Keys.STRING_FIELD_PREFIX_ENABLED));
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull InternalNode node) {
        Generator<?> generator = this.generatorResolver.getCached(node);
        if (generator == null) {
            return GeneratorResult.emptyResult();
        }
        Object value = generator.generate(this.context.getRandom());
        Object processed = this.stringPostProcessor.process(value, node, generator);
        return GeneratorResult.create(processed, generator.hints());
    }
}

