/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed.csv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.instancio.internal.feed.AbstractDataStore;

public class CsvDataStore
extends AbstractDataStore<String[]> {
    public CsvDataStore(String tagKey, List<String[]> data) {
        super(tagKey, data);
    }

    @Override
    protected Map<String, Integer> createFieldIndexMap(List<String[]> data) {
        String[] headers = data.get(0);
        LinkedHashMap<String, Integer> fieldIndexMap = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < headers.length; ++i) {
            fieldIndexMap.put(headers[i], i);
        }
        return fieldIndexMap;
    }

    @Override
    protected Map<String, List<String[]>> groupDataByTag(String tagKey, Map<String, Integer> fieldIndexMap, List<String[]> data) {
        HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
        int tagIndex = fieldIndexMap.getOrDefault(tagKey, -1);
        for (int i = 1; i < data.size(); ++i) {
            String[] row = data.get(i);
            String tag = tagIndex == -1 || tagIndex >= row.length ? null : row[tagIndex];
            ArrayList<String[]> tagData = (ArrayList<String[]>)map.get(tag);
            if (tagData == null) {
                tagData = new ArrayList<String[]>();
                map.put(tag, tagData);
            }
            tagData.add(row);
        }
        return map;
    }

    @Override
    public String[] get(int index) {
        return (String[])this.getData().get(index + 1);
    }

    @Override
    public int size() {
        return this.getData().size() - 1;
    }
}

