/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed;

import java.nio.file.Paths;
import java.util.function.Function;
import org.instancio.FeedApi;
import org.instancio.feed.DataSource;
import org.instancio.feed.DataSourceProvider;
import org.instancio.feed.Feed;
import org.instancio.feed.FormatOptionsProvider;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.RandomHelper;
import org.instancio.internal.feed.csv.InternalCsvFormatOptions;
import org.instancio.internal.feed.datasource.CacheableDataSource;
import org.instancio.internal.feed.datasource.FileDataSource;
import org.instancio.internal.feed.datasource.ResourceDataSource;
import org.instancio.internal.feed.datasource.StringDataSource;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.instancio.settings.FeedDataAccess;
import org.instancio.settings.FeedDataEndAction;
import org.instancio.settings.FeedFormatType;
import org.instancio.settings.Keys;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;
import org.instancio.support.Global;
import org.instancio.support.ThreadLocalSettings;
import org.jetbrains.annotations.Nullable;

public final class InternalFeedContext<F extends Feed> {
    private final Class<F> feedClass;
    private final GeneratorContext generatorContext;
    private final String tagKey;
    private final String tagValue;
    private final DataSource dataSource;
    private final FormatOptionsProvider.FormatOptions formatOptions;
    private final FeedFormatType feedFormatType;
    private final FeedDataAccess feedDataAccess;
    private final FeedDataEndAction feedDataEndAction;

    private InternalFeedContext(Builder<F> builder) {
        this.feedClass = ((Builder)builder).feedClass;
        this.generatorContext = InternalFeedContext.resolveGeneratorContext(builder);
        Settings settings = this.generatorContext.getSettings();
        Feed.Source feedSource = ((Builder)builder).feedClass.getDeclaredAnnotation(Feed.Source.class);
        this.tagKey = InternalFeedContext.resolveTagKey(settings, this.feedClass, ((Builder)builder).tagKey);
        this.tagValue = ((Builder)builder).tagValue != null ? ((Builder)builder).tagValue : settings.get(Keys.FEED_TAG_VALUE);
        this.dataSource = InternalFeedContext.resolveDataSource(feedSource, ((Builder)builder).feedClass, ((Builder)builder).dataSource, this.tagKey);
        this.formatOptions = ((Builder)builder).formatOptions != null ? (FormatOptionsProvider.FormatOptions)((Builder)builder).formatOptions.apply(settings) : null;
        this.feedFormatType = InternalFeedContext.resolveDataFormatType(settings, this.feedClass, ((Builder)builder).feedFormatType);
        this.feedDataAccess = InternalFeedContext.resolveFeedDataAccess(settings, this.feedClass, ((Builder)builder).feedDataAccess);
        this.feedDataEndAction = ((Builder)builder).feedDataEndAction != null ? ((Builder)builder).feedDataEndAction : settings.get(Keys.FEED_DATA_END_ACTION);
    }

    private static FeedFormatType resolveDataFormatType(Settings settings, Class<?> feedClass, FeedFormatType feedFormatType) {
        if (feedFormatType != null) {
            return feedFormatType;
        }
        Feed.FormatType formatType = feedClass.getDeclaredAnnotation(Feed.FormatType.class);
        if (formatType != null) {
            return formatType.value();
        }
        return settings.get(Keys.FEED_FORMAT_TYPE);
    }

    private static FeedDataAccess resolveFeedDataAccess(Settings settings, Class<?> feedClass, FeedDataAccess feedDataAccess) {
        if (feedDataAccess != null) {
            return feedDataAccess;
        }
        Feed.DataAccess dataAccessAnnotation = feedClass.getDeclaredAnnotation(Feed.DataAccess.class);
        return dataAccessAnnotation != null ? dataAccessAnnotation.value() : settings.get(Keys.FEED_DATA_ACCESS);
    }

    private static GeneratorContext resolveGeneratorContext(Builder<?> builder) {
        if (((Builder)builder).generatorContext != null) {
            return ((Builder)builder).generatorContext;
        }
        Settings settings = Global.getPropertiesFileSettings().merge(ThreadLocalSettings.getInstance().get()).merge(((Builder)builder).settings).lock();
        return new GeneratorContext(settings, RandomHelper.resolveRandom(settings.get(Keys.SEED), null));
    }

    private static String resolveTagKey(Settings settings, Class<?> feedClass, String tagKey) {
        if (tagKey != null) {
            return tagKey;
        }
        Feed.TagKey tagKeyAnnotation = feedClass.getDeclaredAnnotation(Feed.TagKey.class);
        if (tagKeyAnnotation != null) {
            return tagKeyAnnotation.value();
        }
        return settings.get(Keys.FEED_TAG_KEY);
    }

    private static DataSource resolveDataSource(Feed.Source feedSource, Class<?> feedClass, DataSource dataSource, String tagKey) {
        if (dataSource != null) {
            if (dataSource instanceof ResourceDataSource || dataSource instanceof FileDataSource) {
                String cacheKey = dataSource.getName() + ":" + tagKey;
                return new CacheableDataSource(dataSource, cacheKey);
            }
            return dataSource;
        }
        if (feedSource != null) {
            if (!feedSource.string().isEmpty()) {
                String cacheKey = feedClass.getName() + ":" + tagKey;
                return new CacheableDataSource(new StringDataSource(feedSource.string()), cacheKey);
            }
            if (!feedSource.file().isEmpty()) {
                String cacheKey = feedSource.file() + ":" + tagKey;
                return new CacheableDataSource(new FileDataSource(Paths.get(feedSource.file(), new String[0])), cacheKey);
            }
            if (!feedSource.resource().isEmpty()) {
                String cacheKey = feedSource.resource() + ":" + tagKey;
                return new CacheableDataSource(new ResourceDataSource(feedSource.resource()), cacheKey);
            }
        }
        throw Fail.withUsageError(ErrorMessageUtils.feedWithoutDataSource(feedClass), new Object[0]);
    }

    public Class<F> getFeedClass() {
        return this.feedClass;
    }

    public String getTagKey() {
        return this.tagKey;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Nullable
    public FormatOptionsProvider.FormatOptions getFormatOptions() {
        return this.formatOptions;
    }

    public GeneratorContext getGeneratorContext() {
        return this.generatorContext;
    }

    public FeedDataAccess getFeedDataAccess() {
        return this.feedDataAccess;
    }

    public FeedDataEndAction getFeedDataEndStrategy() {
        return this.feedDataEndAction;
    }

    public FeedFormatType getDataFormatType() {
        return this.feedFormatType;
    }

    public static <F extends Feed> Builder<F> builder(Class<F> feedClass) {
        return new Builder(feedClass);
    }

    public static <F extends Feed> Builder<F> builder(DataSourceProvider dataSourceProvider) {
        return InternalFeedContext.builder(Feed.class).withDataSource(dataSourceProvider);
    }

    public static final class Builder<F extends Feed>
    implements FeedApi {
        private static final DataSourceProvider.DataSourceFactory DATA_SOURCE_FACTORY = new DataSourceProvider.DataSourceFactory(){};
        private static final FormatOptionsProvider.FormatOptionsFactory DATA_FORMAT_FACTORY = new FormatOptionsProvider.FormatOptionsFactory(){};
        private final Class<F> feedClass;
        private GeneratorContext generatorContext;
        private String tagKey;
        private String tagValue;
        private DataSource dataSource;
        private Function<Settings, FormatOptionsProvider.FormatOptions> formatOptions;
        private FeedFormatType feedFormatType;
        private FeedDataAccess feedDataAccess;
        private FeedDataEndAction feedDataEndAction;
        private Settings settings;

        private Builder(Class<F> feedClass) {
            ApiValidator.isTrue(feedClass != null && feedClass.isInterface(), "Feed must be an interface, but got: %s", feedClass);
            this.feedClass = feedClass;
        }

        public Builder<F> withGeneratorContext(GeneratorContext generatorContext) {
            this.generatorContext = generatorContext;
            return this;
        }

        @Override
        public Builder<F> withTagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        @Override
        public Builder<F> withTagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public Builder<F> withDataSource(DataSourceProvider provider) {
            ApiValidator.notNull(provider, "'dataSourceProvider' must not be null");
            this.dataSource = provider.get(DATA_SOURCE_FACTORY);
            return this;
        }

        @Override
        public Builder<F> formatOptions(FormatOptionsProvider provider) {
            ApiValidator.notNull(provider, "'formatOptionsProvider' must not be null");
            this.formatOptions = useSettings -> {
                InternalCsvFormatOptions.Builder builder = (InternalCsvFormatOptions.Builder)provider.get(DATA_FORMAT_FACTORY);
                return builder.build((Settings)useSettings);
            };
            return this;
        }

        @Override
        public Builder<F> formatType(FeedFormatType feedFormatType) {
            this.feedFormatType = feedFormatType;
            return this;
        }

        @Override
        public Builder<F> dataAccess(FeedDataAccess feedDataAccess) {
            this.feedDataAccess = feedDataAccess;
            return this;
        }

        @Override
        public Builder<F> onDataEnd(FeedDataEndAction feedDataEndAction) {
            this.feedDataEndAction = feedDataEndAction;
            return this;
        }

        public <V> Builder<F> withSetting(SettingKey<V> key, V value) {
            if (this.settings == null) {
                this.settings = Settings.create();
            }
            this.settings.set(key, value);
            return this;
        }

        public Builder<F> withSettings(Settings arg) {
            ApiValidator.notNull(arg, "'settings' must not be null");
            this.settings = this.settings == null ? Settings.from(arg) : this.settings.merge(arg);
            return this;
        }

        public InternalFeedContext<F> build() {
            return new InternalFeedContext(this);
        }
    }
}

