/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.instancio.Assignment;
import org.instancio.FilterPredicate;
import org.instancio.GeneratorSpecProvider;
import org.instancio.Model;
import org.instancio.OnCompleteCallback;
import org.instancio.Random;
import org.instancio.Scope;
import org.instancio.Select;
import org.instancio.TargetSelector;
import org.instancio.feed.Feed;
import org.instancio.feed.FeedProvider;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.ApiMethodSelector;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.Flattener;
import org.instancio.internal.InternalModel;
import org.instancio.internal.RandomHelper;
import org.instancio.internal.RootType;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.context.BooleanSelectorMap;
import org.instancio.internal.context.FillObjectHelper;
import org.instancio.internal.context.ModelContextSelectorMap;
import org.instancio.internal.context.ModelContextSource;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMaps;
import org.instancio.internal.context.SelectorNodeMatchesCollector;
import org.instancio.internal.context.SubtypeSelectorMap;
import org.instancio.internal.context.UnusedEmitItemsReporter;
import org.instancio.internal.context.UnusedSelectorReporter;
import org.instancio.internal.feed.InternalFeedContext;
import org.instancio.internal.feed.InternalFeedProxy;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.generator.misc.ObjectFillingGenerator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.selectors.BlankSelectors;
import org.instancio.internal.selectors.InternalSelector;
import org.instancio.internal.selectors.SelectorProcessor;
import org.instancio.internal.selectors.SetterSelectorHolder;
import org.instancio.internal.spi.InternalServiceProvider;
import org.instancio.internal.spi.InternalServiceProviderContext;
import org.instancio.internal.spi.InternalServiceProviderImpl;
import org.instancio.internal.spi.Providers;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.ServiceLoaders;
import org.instancio.internal.util.SystemProperties;
import org.instancio.internal.util.TypeUtils;
import org.instancio.internal.util.Verify;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.FillType;
import org.instancio.settings.Keys;
import org.instancio.settings.Mode;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;
import org.instancio.support.Global;
import org.instancio.support.ThreadLocalSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelContext {
    private static final Logger LOG = LoggerFactory.getLogger(ModelContext.class);
    private static final List<InternalServiceProvider> INTERNAL_SERVICE_PROVIDERS = CollectionUtils.combine(ServiceLoaders.loadAll(InternalServiceProvider.class), new InternalServiceProviderImpl());
    private final ModelContextSource contextSource;
    private final RootType rootType;
    private final Integer maxDepth;
    private final Long seed;
    private final boolean verbose;
    private final Settings settings;
    private final Random random;
    private final SelectorMaps selectorMaps;
    private final Providers providers;

    private ModelContext(Builder builder) {
        this.contextSource = builder.getModelContextSource();
        this.rootType = new RootType(builder.rootType, this.contextSource.getWithTypeParametersList());
        this.maxDepth = builder.maxDepth;
        this.seed = builder.seed;
        this.verbose = builder.verbose;
        this.settings = ModelContext.createSettings(builder);
        this.random = RandomHelper.resolveRandom(this.settings.get(Keys.SEED), builder.seed);
        GeneratorContext generatorContext = new GeneratorContext(this.settings, this.random);
        this.selectorMaps = new SelectorMaps(this.contextSource, generatorContext);
        this.providers = new Providers(new InternalServiceProviderContext(this.settings, this.random));
        if (builder.fillObject != null) {
            ObjectFillingGenerator generator = new ObjectFillingGenerator(generatorContext, builder.fillObject, builder.fillType);
            this.selectorMaps.getGeneratorSelectorMap().putGenerator(Select.root(), generator);
        }
    }

    private static Settings createSettings(Builder builder) {
        AssignmentType assignmentTypeOverride;
        Settings settings = Global.getPropertiesFileSettings().merge(ThreadLocalSettings.getInstance().get()).merge(builder.settings);
        if (Boolean.TRUE.equals(builder.lenient)) {
            settings.set(Keys.MODE, Mode.LENIENT);
        }
        if ((assignmentTypeOverride = SystemProperties.getAssignmentType()) != null) {
            settings.set(Keys.ASSIGNMENT_TYPE, assignmentTypeOverride);
        }
        LOG.trace("Resolved settings: {}", (Object)settings);
        SetterSelectorHolder holder = builder.setMethodSelectorHolder;
        ApiValidator.failIfMethodSelectorIsUsedWithFieldAssignment(settings.get(Keys.ASSIGNMENT_TYPE), holder.getSetterSelector());
        return settings.lock();
    }

    public List<InternalServiceProvider> getInternalServiceProviders() {
        return INTERNAL_SERVICE_PROVIDERS;
    }

    public Providers getServiceProviders() {
        return this.providers;
    }

    public void reportWarnings() {
        this.reportUnusedSelectorWarnings();
        this.reportEmitGeneratorWarnings();
    }

    private void reportEmitGeneratorWarnings() {
        SelectorMap<Generator<?>> selectorMap = this.selectorMaps.getGeneratorSelectorMap().getSelectorMap();
        UnusedEmitItemsReporter reporter = new UnusedEmitItemsReporter(selectorMap);
        reporter.report();
    }

    void reportUnusedSelectorWarnings() {
        if (this.settings.get(Keys.MODE) == Mode.STRICT && !this.selectorMaps.allEmpty()) {
            new UnusedSelectorReporter(this.getMaxDepth(), this.selectorMaps).report();
        }
    }

    public Map<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> getSelectors(InternalNode rootNode) {
        return new SelectorNodeMatchesCollector(this.selectorMaps).getNodeMatches(rootNode);
    }

    public RootType getRootType() {
        return this.rootType;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Random getRandom() {
        return this.random;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Integer getMaxDepth() {
        return ObjectUtils.defaultIfNull(this.maxDepth, this.settings.get(Keys.MAX_DEPTH));
    }

    public SelectorMaps getSelectorMaps() {
        return this.selectorMaps;
    }

    public boolean isIgnored(InternalNode node) {
        return this.selectorMaps.getIgnoreSelectorMap().isTrue(node);
    }

    public boolean isNullable(InternalNode node) {
        return this.selectorMaps.getWithNullableSelectorMap().isTrue(node);
    }

    public boolean isAccepted(InternalNode node, Object value) {
        Predicate<Object> predicate = this.selectorMaps.getFilterSelectorMap().getPredicate(node);
        if (predicate == null) {
            return true;
        }
        try {
            return predicate.test(value);
        }
        catch (Exception ex) {
            throw Fail.withUsageError(ErrorMessageUtils.filterPredicateErrorMessage(value, node, ex), new Object[0]);
        }
    }

    public Optional<Generator<?>> getGenerator(InternalNode node) {
        return this.selectorMaps.getGeneratorSelectorMap().getGenerator(node);
    }

    public void putGenerator(TargetSelector selector, Generator<?> generator) {
        this.selectorMaps.getGeneratorSelectorMap().putGenerator(selector, generator);
    }

    public Set<TargetSelector> getAssignmentOriginSelectors(InternalNode node) {
        return this.getAssignmentOriginSelectorMap().getSelectorMap().getSelectors(node);
    }

    public List<OnCompleteCallback<?>> getCallbacks(InternalNode node) {
        return this.selectorMaps.getOnCompleteSelectorMap().getCallbacks(node);
    }

    public SubtypeSelectorMap getSubtypeSelectorMap() {
        return this.selectorMaps.getSubtypeSelectorMap();
    }

    public ModelContextSelectorMap getSetModelSelectorMap() {
        return this.selectorMaps.getSetModelSelectorMap();
    }

    public SelectorMap<Feed> getFeedSelectorMap() {
        return this.selectorMaps.getFeedSelectorMap().getSelectorMap();
    }

    public List<InternalAssignment> getAssignments(InternalNode node) {
        return this.selectorMaps.getAssignmentSelectorMap().getAssignments(node);
    }

    public BooleanSelectorMap getAssignmentOriginSelectorMap() {
        return this.selectorMaps.getAssignmentSelectorMap().getOriginSelectors();
    }

    public List<TargetSelector> getAssignmentDestinationSelectors(InternalNode node) {
        return this.selectorMaps.getAssignmentSelectorMap().getDestinationSelectors(node);
    }

    ModelContextSource getContextSource() {
        return this.contextSource;
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.rootType.getType());
        builder.maxDepth = this.maxDepth;
        builder.seed = this.seed;
        builder.settings = this.settings;
        builder.withTypeParametersList = new ArrayList<Type>(this.rootType.getTypeParameters());
        builder.withNullableSet = new LinkedHashSet<TargetSelector>(this.contextSource.getWithNullableSet());
        builder.ignoreSet = new LinkedHashSet<TargetSelector>(this.contextSource.getIgnoreSet());
        builder.generatorMap = new LinkedHashMap(this.contextSource.getGeneratorMap());
        builder.generatorSpecMap = new LinkedHashMap(this.contextSource.getGeneratorSpecMap());
        builder.subtypeMap = new LinkedHashMap(this.contextSource.getSubtypeMap());
        builder.onCompleteMap = new LinkedHashMap(this.contextSource.getOnCompleteMap());
        builder.filterMap = new LinkedHashMap(this.contextSource.getFilterMap());
        builder.assignmentMap = new LinkedHashMap<TargetSelector, List<Assignment>>(CollectionUtils.copyAsLinkedHashMap(this.contextSource.getAssignmentMap()));
        builder.setModelMap = new LinkedHashMap<TargetSelector, ModelContext>(this.contextSource.getSetModelMap());
        builder.feedMap = new LinkedHashMap<TargetSelector, Function<GeneratorContext, Feed>>(this.contextSource.getFeedMap());
        return builder;
    }

    public static Builder builder(Type rootType) {
        return new Builder(rootType);
    }

    public static final class Builder {
        private final Type rootType;
        private List<Type> withTypeParametersList;
        private Object fillObject;
        private FillType fillType;
        private Map<TargetSelector, Class<?>> subtypeMap;
        private Map<TargetSelector, GeneratorSpecProvider<?>> generatorSpecMap;
        private Map<TargetSelector, Generator<?>> generatorMap;
        private Map<TargetSelector, OnCompleteCallback<?>> onCompleteMap;
        private Map<TargetSelector, Predicate<?>> filterMap;
        private Map<TargetSelector, List<Assignment>> assignmentMap;
        private Map<TargetSelector, ModelContext> setModelMap;
        private Map<TargetSelector, Function<GeneratorContext, Feed>> feedMap;
        private Set<TargetSelector> ignoreSet;
        private Set<TargetSelector> withNullableSet;
        private Settings settings;
        private Integer maxDepth;
        private Long seed;
        private Boolean lenient;
        private boolean verbose;
        private final SelectorProcessor selectorProcessor;
        private final SetterSelectorHolder setMethodSelectorHolder = new SetterSelectorHolder();

        private Builder(Type rootType) {
            ApiValidator.validateRootClass(rootType);
            this.rootType = rootType;
            this.selectorProcessor = new SelectorProcessor(TypeUtils.getRawType(rootType), INTERNAL_SERVICE_PROVIDERS, this.setMethodSelectorHolder);
        }

        public Builder withFillObject(Object fillObject) {
            this.fillObject = fillObject;
            List<Type> typeArgs = FillObjectHelper.getTypeArgs(fillObject);
            this.withRootTypeParameters(typeArgs);
            return this;
        }

        public Builder withFillType(FillType fillType) {
            ApiValidator.notNull(fillType, "Fill type must not be null");
            this.fillType = fillType;
            return this;
        }

        public Builder withRootTypeParameters(List<Type> rootTypeParameters) {
            ApiValidator.validateTypeParameters(this.rootType, rootTypeParameters);
            this.withTypeParametersList = new ArrayList<Type>(rootTypeParameters);
            return this;
        }

        private <V> Builder addSelector(Map<TargetSelector, V> map, TargetSelector selector, V value, ApiMethodSelector apiMethodSelector) {
            List<TargetSelector> processed = this.selectorProcessor.process(selector, apiMethodSelector);
            for (TargetSelector s : processed) {
                map.put(s, value);
            }
            return this;
        }

        public Builder withSubtype(TargetSelector selector, Class<?> subtype) {
            ApiValidator.notNull(subtype, "subtype must not be null");
            this.subtypeMap = CollectionUtils.newLinkedHashMapIfNull(this.subtypeMap);
            return this.addSelector(this.subtypeMap, selector, subtype, ApiMethodSelector.SUBTYPE);
        }

        public Builder withGenerator(TargetSelector selector, Generator<?> generator) {
            ApiValidator.validateGeneratorNotNull(generator);
            return this.addGenerator(selector, generator, ApiMethodSelector.GENERATE);
        }

        private Builder addGenerator(TargetSelector selector, Generator<?> generator, ApiMethodSelector apiMethodSelector) {
            this.generatorMap = CollectionUtils.newLinkedHashMapIfNull(this.generatorMap);
            return this.addSelector(this.generatorMap, selector, generator, apiMethodSelector);
        }

        public Builder withSet(TargetSelector selector, Object value) {
            return this.addGenerator(selector, GeneratorDecorator.decorate(() -> value), ApiMethodSelector.SET);
        }

        public Builder withSupplier(TargetSelector selector, Supplier<?> supplier) {
            ApiValidator.validateSupplierNotNull(supplier);
            return this.addGenerator(selector, GeneratorDecorator.decorate(supplier), ApiMethodSelector.SUPPLY);
        }

        public <V> Builder withGeneratorSpec(TargetSelector selector, GeneratorSpecProvider<V> spec) {
            ApiValidator.validateGenerateSecondArgument(spec);
            this.generatorSpecMap = CollectionUtils.newLinkedHashMapIfNull(this.generatorSpecMap);
            return this.addSelector(this.generatorSpecMap, selector, spec, ApiMethodSelector.GENERATE);
        }

        public Builder withOnCompleteCallback(TargetSelector selector, OnCompleteCallback<?> callback) {
            this.onCompleteMap = CollectionUtils.newLinkedHashMapIfNull(this.onCompleteMap);
            return this.addSelector(this.onCompleteMap, selector, callback, ApiMethodSelector.ON_COMPLETE);
        }

        public Builder filter(TargetSelector selector, Predicate<?> predicate) {
            ApiValidator.notNull(predicate, "predicate must not be null");
            return this.addFilterPredicate(selector, predicate, ApiMethodSelector.FILTER);
        }

        public Builder withUnique(TargetSelector selector) {
            FilterPredicate<Object> predicate = new FilterPredicate<Object>(){
                final Set<Object> generatedValues = new HashSet<Object>();

                @Override
                public boolean test(Object obj) {
                    return this.generatedValues.add(obj);
                }
            };
            return this.addFilterPredicate(selector, predicate, ApiMethodSelector.WITH_UNIQUE);
        }

        private Builder addFilterPredicate(TargetSelector selector, Predicate<?> predicate, ApiMethodSelector apiMethodSelector) {
            this.filterMap = CollectionUtils.newLinkedHashMapIfNull(this.filterMap);
            return this.addSelector(this.filterMap, selector, predicate, apiMethodSelector);
        }

        public Builder applyFeed(TargetSelector selector, Feed feed) {
            return this.addFeedFunction(selector, generatorCtx -> feed);
        }

        public Builder applyFeed(TargetSelector selector, FeedProvider provider) {
            return this.addFeedFunction(selector, generatorCtx -> {
                FeedProvider.FeedBuilderFactory factory = new FeedProvider.FeedBuilderFactory(){};
                InternalFeedContext.Builder builder = (InternalFeedContext.Builder)provider.get(factory);
                return InternalFeedProxy.forClass(builder.withGeneratorContext((GeneratorContext)generatorCtx).build());
            });
        }

        private Builder addFeedFunction(TargetSelector selector, Function<GeneratorContext, Feed> feedFn) {
            this.feedMap = CollectionUtils.newLinkedHashMapIfNull(this.feedMap);
            return this.addSelector(this.feedMap, selector, feedFn, ApiMethodSelector.APPLY_FEED);
        }

        public Builder withIgnored(TargetSelector selector) {
            this.ignoreSet = CollectionUtils.newLinkedHashSetIfNull(this.ignoreSet);
            this.ignoreSet.addAll(this.selectorProcessor.process(selector, ApiMethodSelector.IGNORE));
            return this;
        }

        public Builder withNullable(TargetSelector selector) {
            this.withNullableSet = CollectionUtils.newLinkedHashSetIfNull(this.withNullableSet);
            this.withNullableSet.addAll(this.selectorProcessor.process(selector, ApiMethodSelector.WITH_NULLABLE));
            return this;
        }

        public Builder withMaxDepth(int maxDepth) {
            ApiValidator.isTrue(maxDepth >= 0, "Maximum depth must not be negative: %s", maxDepth);
            this.maxDepth = maxDepth;
            return this;
        }

        public Builder withAssignments(Assignment ... assignments) {
            ApiValidator.notNull(assignments, "assignments array must not be null");
            this.assignmentMap = CollectionUtils.newLinkedHashMapIfNull(this.assignmentMap);
            for (Assignment assignment : assignments) {
                ApiValidator.notNull(assignment, "assignments array must not contain null");
                this.processAssignment(assignment);
            }
            return this;
        }

        private void processAssignment(Assignment assignment) {
            List assignments = ((Flattener)((Object)assignment)).flatten();
            for (InternalAssignment a : assignments) {
                List<TargetSelector> origin = this.selectorProcessor.process(a.getOrigin(), ApiMethodSelector.ASSIGN_ORIGIN);
                List<TargetSelector> destinations = this.selectorProcessor.process(a.getDestination(), ApiMethodSelector.ASSIGN_DESTINATION);
                Verify.isTrue(origin.size() == 1, "Origin has multiple selectors", new Object[0]);
                for (TargetSelector destination : destinations) {
                    InternalAssignment processedAssignment = a.toBuilder().origin(origin.get(0)).destination(destination).build();
                    this.assignmentMap.computeIfAbsent(destination, k -> new ArrayList()).add(processedAssignment);
                }
            }
        }

        public <V> Builder withSetting(SettingKey<V> key, V value) {
            if (this.settings == null) {
                this.settings = Settings.create();
            } else if (this.settings.isLocked()) {
                this.settings = Settings.from(this.settings);
            }
            this.settings.set(key, value);
            return this;
        }

        public Builder withSettings(Settings arg) {
            ApiValidator.notNull(arg, "Null Settings provided to withSettings() method");
            this.settings = this.settings == null ? Settings.from(arg) : this.settings.merge(arg);
            return this;
        }

        public Builder withSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder setBlank(TargetSelector selector) {
            if (selector instanceof InternalSelector && ((InternalSelector)selector).isRootSelector()) {
                this.setBlankTargets(new Scope[0]);
            } else {
                List<TargetSelector> processedSelectors = this.selectorProcessor.process(selector, ApiMethodSelector.NONE);
                for (TargetSelector processedSelector : processedSelectors) {
                    InternalSelector target = (InternalSelector)processedSelector;
                    Scope[] effectiveScopes = CollectionUtils.combine(target.getScopes(), target.toScope()).toArray(new Scope[0]);
                    this.setBlankTargets(effectiveScopes);
                }
            }
            return this;
        }

        private void setBlankTargets(Scope ... scopes) {
            this.withSupplier(BlankSelectors.leafSelector().within(scopes), () -> null);
            this.withGeneratorSpec(BlankSelectors.collectionSelector().within(scopes).lenient(), gen -> gen.collection().size(0));
            this.withGeneratorSpec(BlankSelectors.mapSelector().within(scopes).lenient(), gen -> gen.map().size(0));
            this.withGeneratorSpec(BlankSelectors.arraySelector().within(scopes).lenient(), gen -> gen.array().length(0));
        }

        public Builder lenient() {
            this.lenient = true;
            return this;
        }

        public Builder verbose() {
            this.verbose = true;
            return this;
        }

        public Builder useModelAsTypeArgument(ModelContext otherContext) {
            this.seed = otherContext.seed;
            this.withTypeParametersList = Collections.singletonList(otherContext.getRootType().getType());
            ModelContextSource src = otherContext.contextSource;
            this.withNullableSet = new LinkedHashSet<TargetSelector>(src.getWithNullableSet());
            this.ignoreSet = new LinkedHashSet<TargetSelector>(src.getIgnoreSet());
            this.generatorMap = new LinkedHashMap(src.getGeneratorMap());
            this.generatorSpecMap = new LinkedHashMap(src.getGeneratorSpecMap());
            this.subtypeMap = new LinkedHashMap(src.getSubtypeMap());
            this.onCompleteMap = new LinkedHashMap(src.getOnCompleteMap());
            this.filterMap = new LinkedHashMap(src.getFilterMap());
            this.assignmentMap = new LinkedHashMap<TargetSelector, List<Assignment>>(src.getAssignmentMap());
            this.setModelMap = new LinkedHashMap<TargetSelector, ModelContext>(src.getSetModelMap());
            this.feedMap = new LinkedHashMap<TargetSelector, Function<GeneratorContext, Feed>>(src.getFeedMap());
            this.maxDepth = otherContext.maxDepth == null ? null : Integer.valueOf(otherContext.maxDepth + 1);
            this.settings = Settings.from(otherContext.settings).set(Keys.MAX_DEPTH, otherContext.settings.get(Keys.MAX_DEPTH) + 1).lock();
            return this;
        }

        public Builder setModel(TargetSelector modelSelector, Model<?> model) {
            TargetSelector actualModelSelector = modelSelector instanceof InternalSelector && ((InternalSelector)modelSelector).isRootSelector() ? Select.all(TypeUtils.getRawType(this.rootType)).atDepth(0) : modelSelector;
            this.setModelMap = CollectionUtils.newLinkedHashMapIfNull(this.setModelMap);
            ModelContext otherCtx = ((InternalModel)model).getModelContext();
            List<TargetSelector> processedSelectors = this.selectorProcessor.process(actualModelSelector, ApiMethodSelector.SET_MODEL);
            for (TargetSelector modelTarget : processedSelectors) {
                this.setModelMap.put(modelTarget, otherCtx);
            }
            return this;
        }

        private ModelContextSource getModelContextSource() {
            return new ModelContextSource(this.withTypeParametersList, this.subtypeMap, this.generatorSpecMap, this.generatorMap, this.onCompleteMap, this.filterMap, this.assignmentMap, this.setModelMap, this.feedMap, this.ignoreSet, this.withNullableSet);
        }

        public ModelContext build() {
            return new ModelContext(this);
        }
    }
}

