/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.annotation.AnnotationGeneratorFn;
import org.instancio.internal.annotation.AnnotationHandlerMap;
import org.instancio.internal.annotation.AnnotationLibraryFacade;
import org.instancio.internal.annotation.AnnotationMap;
import org.instancio.internal.annotation.FieldAnnotationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAnnotationLibraryFacade
implements AnnotationLibraryFacade {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAnnotationLibraryFacade.class);
    private final Map<Class<? extends Annotation>, AnnotationGeneratorFn> primaryAnnotations = new HashMap<Class<? extends Annotation>, AnnotationGeneratorFn>();

    AbstractAnnotationLibraryFacade() {
    }

    protected abstract AnnotationHandlerMap getAnnotationHandlerMap();

    final <A extends Annotation> void putPrimary(Supplier<Class<A>> annotationTypeSupplier, AnnotationGeneratorFn annotationGeneratorFn) {
        try {
            this.primaryAnnotations.put(annotationTypeSupplier.get(), annotationGeneratorFn);
        }
        catch (NoClassDefFoundError error) {
            LOG.trace("Annotation not available on classpath: {}", (Object)error.toString());
        }
    }

    @Override
    public final boolean isPrimary(Class<? extends Annotation> annotationType) {
        return this.primaryAnnotations.containsKey(annotationType);
    }

    @Override
    public final void consumeAnnotations(AnnotationMap annotationMap, GeneratorSpec<?> spec, Class<?> targetClass, GeneratorContext generatorContext) {
        AnnotationHandlerMap annotationHandlerMap = this.getAnnotationHandlerMap();
        Collection<Annotation> annotations = annotationMap.getAnnotations();
        for (Annotation annotation : annotations) {
            FieldAnnotationHandler handler = annotationHandlerMap.get(annotation);
            if (handler == null) continue;
            handler.process(annotation, spec, targetClass, generatorContext);
            annotationMap.remove(annotation.annotationType());
        }
    }

    @Override
    public Generator<?> resolveGenerator(Annotation annotation, GeneratorContext context) {
        AnnotationGeneratorFn fn = this.primaryAnnotations.get(annotation.annotationType());
        return fn == null ? null : fn.apply(annotation, context);
    }
}

