/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.util.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RootType {
    private static final Logger LOG = LoggerFactory.getLogger(RootType.class);
    private final Type type;
    private final List<Type> typeParameters;
    private final Map<Type, Type> typeMap;

    public RootType(@NotNull Type type, @NotNull List<Type> typeParameters) {
        this.type = type;
        this.typeParameters = typeParameters;
        this.typeMap = RootType.buildRootTypeMap(type, typeParameters);
    }

    public Type getType() {
        return this.type;
    }

    public List<Type> getTypeParameters() {
        return this.typeParameters;
    }

    @Nullable
    public Type getTypeMapping(Type type) {
        return this.typeMap.get(type);
    }

    private static Map<Type, Type> buildRootTypeMap(Type rootType, List<Type> rootTypeParameters) {
        if (rootType instanceof ParameterizedType || rootType instanceof GenericArrayType) {
            return Collections.emptyMap();
        }
        Class rootClass = TypeUtils.getRawType(rootType);
        ApiValidator.validateTypeParameters(rootClass, rootTypeParameters);
        Class<Object> targetClass = rootClass.isArray() ? rootClass.getComponentType() : rootClass;
        TypeVariable<Class<Object>>[] typeVariables = targetClass.getTypeParameters();
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        for (int i = 0; i < typeVariables.length; ++i) {
            TypeVariable<Class<Object>> typeVariable = typeVariables[i];
            Type actualType = rootTypeParameters.get(i);
            LOG.trace("Mapping type variable '{}' to '{}'", typeVariable, (Object)actualType);
            typeMap.put(typeVariable, actualType);
        }
        RootType.populateTypeMapFromGenericSuperclass(rootClass, typeMap);
        return typeMap;
    }

    private static void populateTypeMapFromGenericSuperclass(Class<?> rootClass, Map<Type, Type> typeMap) {
        Type gsClass = rootClass.getGenericSuperclass();
        if (gsClass instanceof ParameterizedType) {
            ParameterizedType genericSuperclass = (ParameterizedType)gsClass;
            Class rawType = TypeUtils.getRawType(genericSuperclass.getRawType());
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            Type[] actualTypeArguments = genericSuperclass.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (actualTypeArguments[i] instanceof TypeVariable) continue;
                TypeVariable typeVariable = typeParameters[i];
                Class actualType = TypeUtils.getRawType(actualTypeArguments[i]);
                LOG.trace("Mapping type variable '{}' to '{}'", typeVariable, actualType);
                typeMap.put(typeVariable, actualType);
            }
        }
        if (gsClass != null) {
            RootType.populateTypeMapFromGenericSuperclass(TypeUtils.getRawType(gsClass), typeMap);
        }
    }
}

