/*
 * Decompiled with CFR 0.152.
 */
package org.instancio;

import java.lang.reflect.Field;
import java.util.function.Predicate;
import org.instancio.FieldSelectorBuilder;
import org.instancio.GetMethodSelector;
import org.instancio.GroupableSelector;
import org.instancio.PredicateSelector;
import org.instancio.Scope;
import org.instancio.Selector;
import org.instancio.SelectorGroup;
import org.instancio.SetMethodSelector;
import org.instancio.TargetSelector;
import org.instancio.TypeSelectorBuilder;
import org.instancio.documentation.ExperimentalApi;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.selectors.FieldSelectorBuilderImpl;
import org.instancio.internal.selectors.PredicateScopeImpl;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.selectors.PrimitiveAndWrapperSelectorImpl;
import org.instancio.internal.selectors.ScopeImpl;
import org.instancio.internal.selectors.SelectorGroupImpl;
import org.instancio.internal.selectors.SelectorImpl;
import org.instancio.internal.selectors.TargetClass;
import org.instancio.internal.selectors.TargetFieldName;
import org.instancio.internal.selectors.TargetGetterReference;
import org.instancio.internal.selectors.TargetSetterName;
import org.instancio.internal.selectors.TargetSetterReference;
import org.instancio.internal.selectors.TypeSelectorBuilderImpl;

public final class Select {
    public static FieldSelectorBuilder fields() {
        return new FieldSelectorBuilderImpl();
    }

    public static TypeSelectorBuilder types() {
        return new TypeSelectorBuilderImpl();
    }

    public static PredicateSelector fields(Predicate<Field> predicate) {
        ApiValidator.notNull(predicate, "Field predicate must not be null");
        return PredicateSelectorImpl.builder().fieldPredicate(predicate).build();
    }

    public static PredicateSelector types(Predicate<Class<?>> predicate) {
        ApiValidator.notNull(predicate, "Type predicate must not be null");
        return PredicateSelectorImpl.builder().typePredicate(predicate).build();
    }

    public static Selector all(Class<?> type) {
        ApiValidator.notNull(type, "Class must not be null");
        return SelectorImpl.builder().target(new TargetClass(type)).build();
    }

    public static SelectorGroup all(GroupableSelector ... selectors) {
        ApiValidator.notEmpty(selectors, "Selector group must contain at least one selector", new Object[0]);
        return new SelectorGroupImpl(selectors);
    }

    public static Selector field(Class<?> declaringClass, String fieldName) {
        ApiValidator.notNull(declaringClass, "declaring class must not be null");
        ApiValidator.notNull(fieldName, "field name must not be null");
        return SelectorImpl.builder().target(new TargetFieldName(declaringClass, fieldName)).build();
    }

    public static Selector field(String fieldName) {
        ApiValidator.notNull(fieldName, "field name must not be null");
        return SelectorImpl.builder().target(new TargetFieldName(null, fieldName)).build();
    }

    public static <T, R> Selector field(GetMethodSelector<T, R> methodReference) {
        ApiValidator.notNull(methodReference, "getter method reference must not be null");
        return SelectorImpl.builder().target(new TargetGetterReference(methodReference)).build();
    }

    @ExperimentalApi
    public static Selector setter(String methodName) {
        return Select.setter(null, methodName, null);
    }

    @ExperimentalApi
    public static Selector setter(Class<?> declaringClass, String methodName) {
        return Select.setter(declaringClass, methodName, null);
    }

    @ExperimentalApi
    public static Selector setter(Class<?> declaringClass, String methodName, Class<?> parameterType) {
        ApiValidator.notNull(methodName, "method name must not be null");
        return SelectorImpl.builder().target(new TargetSetterName(declaringClass, methodName, parameterType)).build();
    }

    @ExperimentalApi
    public static <T, U> Selector setter(SetMethodSelector<T, U> methodReference) {
        ApiValidator.notNull(methodReference, "setter method reference must not be null");
        return SelectorImpl.builder().target(new TargetSetterReference(methodReference)).build();
    }

    public static TargetSelector root() {
        return SelectorImpl.createRootSelector();
    }

    public static Selector allStrings() {
        return Select.all(String.class);
    }

    public static Selector allBytes() {
        return new PrimitiveAndWrapperSelectorImpl(Byte.TYPE, Byte.class);
    }

    public static Selector allFloats() {
        return new PrimitiveAndWrapperSelectorImpl(Float.TYPE, Float.class);
    }

    public static Selector allShorts() {
        return new PrimitiveAndWrapperSelectorImpl(Short.TYPE, Short.class);
    }

    public static Selector allInts() {
        return new PrimitiveAndWrapperSelectorImpl(Integer.TYPE, Integer.class);
    }

    public static Selector allLongs() {
        return new PrimitiveAndWrapperSelectorImpl(Long.TYPE, Long.class);
    }

    public static Selector allDoubles() {
        return new PrimitiveAndWrapperSelectorImpl(Double.TYPE, Double.class);
    }

    public static Selector allBooleans() {
        return new PrimitiveAndWrapperSelectorImpl(Boolean.TYPE, Boolean.class);
    }

    public static Selector allChars() {
        return new PrimitiveAndWrapperSelectorImpl(Character.TYPE, Character.class);
    }

    public static Scope scope(Class<?> targetClass, String fieldName) {
        return new ScopeImpl(new TargetFieldName(targetClass, fieldName), null);
    }

    public static Scope scope(Class<?> targetClass) {
        ApiValidator.notNull(targetClass, "Scope class must not be null");
        return new ScopeImpl(new TargetClass(targetClass), null);
    }

    public static <T, R> Scope scope(GetMethodSelector<T, R> methodReference) {
        ApiValidator.notNull(methodReference, "getter method reference must not be null");
        return new ScopeImpl(new TargetGetterReference(methodReference), null);
    }

    @ExperimentalApi
    public static Scope scope(PredicateSelector selector) {
        return new PredicateScopeImpl(selector);
    }

    private Select() {
    }
}

