/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.math.BigDecimal;

public class NumericBounds {
    private static final BigDecimal INTEGER_ZERO_MIN = new BigDecimal("-0.9");
    private static final BigDecimal INTEGER_ZERO_MAX = new BigDecimal("0.9");
    private final BigDecimal min;
    private final BigDecimal max;

    public NumericBounds(BigDecimal min, BigDecimal max) {
        this.min = min;
        this.max = max;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public NumericBounds updateBounds(int integer) {
        if (integer == 0) {
            return new NumericBounds(INTEGER_ZERO_MIN, INTEGER_ZERO_MAX);
        }
        BigDecimal lowerBound = BigDecimal.TEN.pow(integer).negate().add(BigDecimal.ONE);
        BigDecimal upperBound = BigDecimal.TEN.pow(integer).subtract(BigDecimal.ONE);
        BigDecimal newMin = this.min.max(lowerBound);
        BigDecimal newMax = this.max.max(lowerBound).min(upperBound);
        return new NumericBounds(newMin, newMax);
    }
}

