/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.reflect.Field;
import java.util.List;
import org.instancio.GetMethodSelector;
import org.instancio.internal.selectors.MethodRef;
import org.instancio.internal.selectors.Target;
import org.instancio.internal.selectors.TargetField;
import org.instancio.internal.spi.InternalServiceProvider;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.jetbrains.annotations.NotNull;

public final class TargetGetterReference
implements Target {
    private final GetMethodSelector<?, ?> selector;

    public TargetGetterReference(GetMethodSelector<?, ?> selector) {
        this.selector = selector;
    }

    @Override
    public Class<?> getTargetClass() {
        return null;
    }

    @Override
    public Target withRootClass(Target.TargetContext targetContext) {
        MethodRef mr = MethodRef.from(this.selector);
        Field field = this.resolveFieldFromGetterMethodReference(targetContext.getInternalServiceProviders(), mr.getTargetClass(), mr.getMethodName());
        return new TargetField(field);
    }

    @NotNull
    private Field resolveFieldFromGetterMethodReference(List<InternalServiceProvider> internalServiceProviders, Class<?> declaringClass, String methodName) {
        for (InternalServiceProvider provider : internalServiceProviders) {
            Field field;
            InternalServiceProvider.InternalGetterMethodFieldResolver resolver = provider.getGetterMethodFieldResolver();
            if (resolver == null || (field = resolver.resolveField(declaringClass, methodName)) == null) continue;
            return field;
        }
        throw Fail.withUsageError(ErrorMessageUtils.unableToResolveFieldFromMethodRef(declaringClass, methodName), new Object[0]);
    }

    public String toString() {
        MethodRef mr = MethodRef.from(this.selector);
        return "field(" + mr.getTargetClass().getSimpleName() + "::" + mr.getMethodName() + ')';
    }
}

