/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.codehaus.groovy.runtime.ConvertedClosure;
import org.codehaus.groovy.runtime.MethodClosure;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.ReflectionUtils;

final class MethodRef {
    private final Class<?> targetClass;
    private final String methodName;

    private MethodRef(Class<?> targetClass, String methodName) {
        this.targetClass = targetClass;
        this.methodName = methodName;
    }

    static MethodRef from(Serializable methodRef) {
        try {
            MethodRef groovyMethodRef;
            if (GroovySupport.isGroovyPresent() && (groovyMethodRef = GroovySupport.methodRef(methodRef)) != null) {
                return groovyMethodRef;
            }
            Class<?> methodRefClass = methodRef.getClass();
            Method replaceMethod = methodRefClass.getDeclaredMethod("writeReplace", new Class[0]);
            ReflectionUtils.setAccessible(replaceMethod);
            SerializedLambda lambda = (SerializedLambda)replaceMethod.invoke((Object)methodRef, new Object[0]);
            String className = lambda.getImplClass().replace('/', '.');
            ClassLoader classLoader = ObjectUtils.defaultIfNull(methodRefClass.getClassLoader(), MethodRef.class.getClassLoader());
            Class<?> targetClass = Class.forName(className, true, classLoader);
            String implMethodName = lambda.getImplMethodName();
            return new MethodRef(targetClass, implMethodName);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw Fail.withUsageError("unable to resolve method name from selector", ex);
        }
    }

    Class<?> getTargetClass() {
        return this.targetClass;
    }

    String getMethodName() {
        return this.methodName;
    }

    private static final class GroovySupport {
        private static final boolean IS_GROOVY_PRESENT = ReflectionUtils.loadClass("groovy.lang.Closure") != null;

        private GroovySupport() {
        }

        static boolean isGroovyPresent() {
            return IS_GROOVY_PRESENT;
        }

        static MethodRef methodRef(Object methodRef) {
            ConvertedClosure convertedClosure;
            Object maybeMethodClosure;
            if (!(methodRef instanceof Proxy)) {
                return null;
            }
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(methodRef);
            if (invocationHandler instanceof ConvertedClosure && (maybeMethodClosure = (convertedClosure = (ConvertedClosure)invocationHandler).getDelegate()) instanceof MethodClosure) {
                MethodClosure methodClosure = (MethodClosure)maybeMethodClosure;
                Class delegate = (Class)methodClosure.getDelegate();
                return new MethodRef(delegate, methodClosure.getMethod());
            }
            return null;
        }
    }
}

