/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.TypeResolverFacade;
import org.instancio.internal.util.SealedClassUtils;
import org.instancio.internal.util.TypeUtils;
import org.instancio.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SubtypeResolver {
    private static final Logger LOG = LoggerFactory.getLogger(SubtypeResolver.class);
    private final ModelContext modelContext;
    private final TypeResolverFacade typeResolverFacade;

    SubtypeResolver(ModelContext modelContext) {
        this.modelContext = modelContext;
        this.typeResolverFacade = new TypeResolverFacade(modelContext.getServiceProviders().getTypeResolvers());
    }

    Optional<Class<?>> resolveSubtype(@NotNull InternalNode node) {
        Optional<Class<?>> subtype = this.getSubtype(node);
        if (subtype.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Resolved subtype: {} -> {}", (Object)node.getRawType().getName(), (Object)subtype.get().getName());
            }
            return subtype;
        }
        if (SealedClassUtils.isSealedAbstractType(node.getTargetClass()) && (node.is(NodeKind.POJO) || node.is(NodeKind.RECORD))) {
            List<Class<?>> impls = SealedClassUtils.getSealedClassImplementations(node.getTargetClass());
            return Optional.of(this.modelContext.getRandom().oneOf(impls));
        }
        return Optional.ofNullable(SubtypeResolver.resolveSubtypeFromAncestors(node));
    }

    private Optional<Class<?>> getSubtype(InternalNode node) {
        Optional<Class<?>> subtype = this.modelContext.getSubtypeSelectorMap().getSubtype(node);
        if (subtype.isPresent()) {
            return subtype;
        }
        Settings settings = this.modelContext.getSettings();
        Class<?> subtypeFromSettings = settings.getSubtypeMap().get(node.getRawType());
        return subtypeFromSettings == null ? this.typeResolverFacade.resolve(node.getRawType()) : Optional.of(subtypeFromSettings);
    }

    private static Class<?> resolveSubtypeFromAncestors(InternalNode node) {
        for (InternalNode next = node; next != null; next = next.getParent()) {
            Type actualType = next.getTypeMap().get(node.getRawType());
            if (actualType == null) continue;
            return TypeUtils.getRawType(actualType);
        }
        return null;
    }
}

