/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.instancio.internal.RootType;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.TypeUtils;
import org.jetbrains.annotations.NotNull;

public final class NodeTypeMap {
    private final RootType rootType;
    private final Map<Type, Type> typeMap;

    NodeTypeMap(@NotNull Type genericType, @NotNull RootType rootType, @NotNull Map<Type, Type> subtypeMappingTypeMap) {
        this.rootType = rootType;
        this.typeMap = this.buildTypeMap(genericType, subtypeMappingTypeMap);
    }

    public RootType getRootType() {
        return this.rootType;
    }

    public Type get(Type type) {
        return this.typeMap.get(type);
    }

    public Type getOrDefault(Type type, Type defaultValue) {
        return this.typeMap.getOrDefault(type, defaultValue);
    }

    public int size() {
        return this.typeMap.size();
    }

    private Map<Type, Type> buildTypeMap(Type type, Map<Type, Type> subtypeMappingTypeMap) {
        Type mappedType;
        HashMap<Type, Type> map = new HashMap<Type, Type>(subtypeMappingTypeMap);
        if (type instanceof Class) {
            return map;
        }
        if (type instanceof TypeVariable && (mappedType = this.rootType.getTypeMapping(type)) != null) {
            map.put(type, mappedType);
            return map;
        }
        if (type instanceof ParameterizedType) {
            Class rawType = TypeUtils.getRawType(type);
            Type[] typeArgs = ((ParameterizedType)type).getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
            for (int i = 0; i < typeArgs.length; ++i) {
                Type mappedType2 = this.resolveTypeMapping(typeArgs[i]);
                map.put(typeVars[i], ObjectUtils.defaultIfNull(mappedType2, typeArgs[i]));
            }
        }
        return map;
    }

    private Type resolveTypeMapping(Type type) {
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType) {
            return type;
        }
        if (type instanceof TypeVariable) {
            return this.rootType.getTypeMapping(type);
        }
        if (type instanceof WildcardType) {
            WildcardType wType = (WildcardType)type;
            return this.resolveTypeMapping(wType.getUpperBounds()[0]);
        }
        throw new UnsupportedOperationException("Unsupported type: " + type.getClass());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeTypeMap)) {
            return false;
        }
        NodeTypeMap other = (NodeTypeMap)o;
        return Objects.equals(this.typeMap, other.typeMap);
    }

    public int hashCode() {
        return this.typeMap == null ? 0 : this.typeMap.hashCode();
    }
}

