/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.text;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.WordTemplateSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.text.WordGenerator;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.StringUtils;

public class WordTemplateGenerator
extends AbstractGenerator<String>
implements WordTemplateSpec {
    private final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();
    private final WordGenerator wordGenerator;
    private final String template;

    public WordTemplateGenerator(GeneratorContext context, String template) {
        super(context);
        this.wordGenerator = new WordGenerator(context);
        this.template = ApiValidator.notNull(template, "'template' must not be null");
    }

    @Override
    public String apiMethod() {
        return "wordTemplate()";
    }

    @Override
    public WordTemplateGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        List<String> templateKeys = StringUtils.getTemplateKeys(this.template);
        String result = this.template;
        for (String templateKey : templateKeys) {
            WordGenerator.WordClass wordClass = WordGenerator.WordClass.getByKey(templateKey.toLowerCase(Locale.ROOT));
            if (wordClass == null) {
                String reason = String.format("invalid template key '${%s}'", templateKey);
                throw Fail.withUsageError(ErrorMessageUtils.invalidStringTemplate(this.template, reason), new Object[0]);
            }
            String word = (String)this.wordGenerator.wordClass(wordClass).generate(random);
            if (Character.isUpperCase(templateKey.charAt(0))) {
                word = Character.isUpperCase(templateKey.charAt(templateKey.length() - 1)) ? word.toUpperCase(Locale.ROOT) : Character.toUpperCase(word.charAt(0)) + word.substring(1);
            }
            result = this.regexPattern(templateKey).matcher(result).replaceFirst(word);
        }
        return result;
    }

    private Pattern regexPattern(String templateKey) {
        Pattern p = this.patternCache.get(templateKey);
        if (p == null) {
            p = Pattern.compile("\\$\\{" + templateKey + '}');
            this.patternCache.put(templateKey, p);
        }
        return p;
    }
}

