/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.shuffle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.ShuffleSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.CollectionUtils;

public class ShuffleGenerator<T>
extends AbstractGenerator<Collection<T>>
implements ShuffleSpec<T> {
    private List<T> items;

    public ShuffleGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return null;
    }

    @Override
    @SafeVarargs
    public final ShuffleGenerator<T> shuffle(T ... array) {
        ApiValidator.notNull(array, "array must not be null");
        this.items = CollectionUtils.asUnmodifiableList(array);
        return this;
    }

    @Override
    public ShuffleGenerator<T> shuffle(Collection<T> collection) {
        ApiValidator.notNull(collection, "collection must not be null");
        this.items = Collections.unmodifiableList(new ArrayList<T>(collection));
        return this;
    }

    @Override
    public ShuffleGenerator<T> nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected Collection<T> tryGenerateNonNull(Random random) {
        ArrayList<T> shuffledCopy = new ArrayList<T>(this.items);
        CollectionUtils.shuffle(shuffledCopy, random);
        return shuffledCopy;
    }
}

