/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.misc;

import org.instancio.Random;
import org.instancio.documentation.InternalApi;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.settings.FillType;
import org.instancio.settings.Keys;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
public final class ObjectFillingGenerator
extends AbstractGenerator<Object> {
    private final Object object;
    private final AfterGenerate afterGenerate;

    public ObjectFillingGenerator(@NotNull GeneratorContext generatorContext, @NotNull Object object, @Nullable FillType fillType) {
        super(generatorContext);
        this.object = object;
        this.afterGenerate = this.resolveAfterGenerate(fillType);
    }

    @Override
    public String apiMethod() {
        return null;
    }

    @Override
    protected Object tryGenerateNonNull(Random random) {
        return this.object;
    }

    @Override
    public Hints hints() {
        return Hints.afterGenerate(this.afterGenerate);
    }

    private AfterGenerate resolveAfterGenerate(@Nullable FillType userSuppliedFillType) {
        FillType fillType = ObjectUtils.defaultIfNull(userSuppliedFillType, () -> this.getContext().getSettings().get(Keys.FILL_TYPE));
        if (fillType == FillType.POPULATE_NULLS) {
            return AfterGenerate.POPULATE_NULLS;
        }
        if (fillType == FillType.POPULATE_NULLS_AND_DEFAULT_PRIMITIVES) {
            return AfterGenerate.POPULATE_NULLS_AND_DEFAULT_PRIMITIVES;
        }
        return AfterGenerate.APPLY_SELECTORS;
    }
}

