/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.spatial;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.CoordinateSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.lang.DoubleGenerator;

public class CoordinateGenerator
extends AbstractGenerator<Double>
implements CoordinateSpec {
    private final DoubleGenerator delegate;
    private CoordinateType type = CoordinateType.LATITUDE;

    public CoordinateGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new DoubleGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "coordinate()";
    }

    @Override
    protected Double tryGenerateNonNull(Random random) {
        if (this.type == CoordinateType.LONGITUDE) {
            return this.delegate.range(-180.0, 180.0).generate(random);
        }
        return this.delegate.range(-90.0, 90.0).generate(random);
    }

    @Override
    public CoordinateGenerator lat() {
        this.type = CoordinateType.LATITUDE;
        return this;
    }

    @Override
    public CoordinateGenerator lon() {
        this.type = CoordinateType.LONGITUDE;
        return this;
    }

    @Override
    public CoordinateGenerator nullable() {
        super.nullable();
        return this;
    }

    private static enum CoordinateType {
        LATITUDE,
        LONGITUDE;

    }
}

