/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.id.bra;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.bra.CpfSpec;
import org.instancio.internal.generator.AbstractGenerator;

public class CpfGenerator
extends AbstractGenerator<String>
implements CpfSpec {
    private static final int CPF_LENGTH = 9;
    private boolean format;

    public CpfGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public CpfGenerator formatted() {
        this.format = true;
        return this;
    }

    @Override
    public String apiMethod() {
        return "cpf()";
    }

    @Override
    public CpfGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        String baseCpf = random.digits(9);
        int firstDigitVerifier = this.generateFirstDigit(baseCpf);
        int secondDigitVerifier = this.generateSecondDigit(baseCpf, firstDigitVerifier);
        if (!this.format) {
            return baseCpf + firstDigitVerifier + secondDigitVerifier;
        }
        return this.format(baseCpf, String.format("%d%d", firstDigitVerifier, secondDigitVerifier));
    }

    String format(String baseCPF, String digits) {
        return baseCPF.substring(0, 3) + '.' + baseCPF.substring(3, 6) + '.' + baseCPF.substring(6, 9) + '-' + digits;
    }

    private int generateFirstDigit(String baseCpf) {
        return this.generateDigit(baseCpf, 1);
    }

    private int generateSecondDigit(String baseCpf, int firstDigit) {
        return this.generateDigit(baseCpf + firstDigit, 0);
    }

    private int generateDigit(String baseCpf, int initialWeight) {
        int weight = initialWeight;
        int sum = 0;
        for (char digit : baseCpf.toCharArray()) {
            sum += Character.getNumericValue(digit) * weight;
            ++weight;
        }
        int result = sum % 11;
        if (result == 10) {
            return 0;
        }
        return result;
    }
}

