/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.id;

import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.EanSpec;
import org.instancio.internal.generator.checksum.BaseModCheckGenerator;

public class EanGenerator
extends BaseModCheckGenerator
implements EanSpec {
    private EanType type = EanType.EAN13;

    public EanGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "ean()";
    }

    @Override
    public EanGenerator type13() {
        this.type = EanType.EAN13;
        return this;
    }

    @Override
    public EanGenerator type8() {
        this.type = EanType.EAN8;
        return this;
    }

    @Override
    public EanGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected int payloadLength() {
        return this.type.length - 1;
    }

    @Override
    protected int even(int position) {
        return 3;
    }

    @Override
    protected boolean sumDigits() {
        return false;
    }

    private static enum EanType {
        EAN8(8),
        EAN13(13);

        private final int length;

        private EanType(int length) {
            this.length = length;
        }
    }
}

