/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.array;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.instancio.Random;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.hints.ArrayHint;
import org.instancio.generator.specs.ArrayGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.NumberUtils;
import org.instancio.settings.Keys;

public class ArrayGenerator<T>
extends AbstractGenerator<T>
implements ArrayGeneratorSpec<T> {
    protected int minLength;
    protected int maxLength;
    private boolean nullableElements;
    private Class<?> arrayType;
    private List<Object> withElements;

    public ArrayGenerator(GeneratorContext context) {
        super(context);
        this.minLength = context.getSettings().get(Keys.ARRAY_MIN_LENGTH);
        this.maxLength = context.getSettings().get(Keys.ARRAY_MAX_LENGTH);
        super.nullable(context.getSettings().get(Keys.ARRAY_NULLABLE));
        this.nullableElements = context.getSettings().get(Keys.ARRAY_ELEMENTS_NULLABLE);
    }

    public ArrayGenerator(GeneratorContext context, Class<?> arrayType) {
        this(context);
        this.arrayType = arrayType;
    }

    @Override
    public String apiMethod() {
        return "array()";
    }

    @Override
    public ArrayGenerator<T> minLength(int length) {
        this.minLength = ApiValidator.validateLength(length);
        this.maxLength = NumberUtils.calculateNewMaxSize(this.maxLength, this.minLength);
        return this;
    }

    @Override
    public ArrayGenerator<T> maxLength(int length) {
        this.maxLength = ApiValidator.validateLength(length);
        this.minLength = NumberUtils.calculateNewMinSize(this.minLength, this.maxLength);
        return this;
    }

    @Override
    public ArrayGenerator<T> length(int length) {
        this.maxLength = ApiValidator.validateLength(length);
        this.minLength = length;
        return this;
    }

    @Override
    public ArrayGenerator<T> nullable() {
        super.nullable();
        return this;
    }

    @Override
    public ArrayGenerator<T> nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    @Override
    public ArrayGenerator<T> nullableElements() {
        this.nullableElements = true;
        return this;
    }

    @Override
    public ArrayGenerator<T> subtype(Class<?> type) {
        ApiValidator.isTrue(type != null && type.isArray(), "type must be an array: %s", type);
        this.arrayType = type;
        return this;
    }

    @Override
    @SafeVarargs
    public final ArrayGenerator<T> with(T ... elements) {
        ApiValidator.notEmpty(elements, "'array().with(...)' must contain at least one element", new Object[0]);
        if (this.withElements == null) {
            this.withElements = new ArrayList<Object>(elements.length);
        }
        Collections.addAll(this.withElements, elements);
        return this;
    }

    @Override
    protected T tryGenerateNonNull(Random random) {
        int length = random.intRange(this.minLength, this.maxLength) + (this.withElements == null ? 0 : this.withElements.size());
        return (T)Array.newInstance(this.arrayType.getComponentType(), length);
    }

    @Override
    public Hints hints() {
        return Hints.builder().afterGenerate(AfterGenerate.POPULATE_ALL).with(ArrayHint.builder().nullableElements(this.nullableElements).withElements(this.withElements).shuffle(!CollectionUtils.isNullOrEmpty(this.withElements)).build()).with(InternalGeneratorHint.builder().targetClass(this.arrayType).build()).build();
    }
}

