/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.instancio.internal.feed.AbstractDataStore;

public class JsonDataStore
extends AbstractDataStore<JsonNode> {
    public JsonDataStore(String tagKey, List<JsonNode> data) {
        super(tagKey, data);
    }

    @Override
    protected Map<String, Integer> createFieldIndexMap(List<JsonNode> data) {
        LinkedHashMap<String, Integer> fieldIndexMap = new LinkedHashMap<String, Integer>();
        JsonNode firstRecord = data.get(0);
        Set headers = firstRecord.properties();
        int i = 0;
        for (Map.Entry entry : headers) {
            fieldIndexMap.put((String)entry.getKey(), i);
            ++i;
        }
        return fieldIndexMap;
    }

    @Override
    protected Map<String, List<JsonNode>> groupDataByTag(String tagKey, Map<String, Integer> fieldIndexMap, List<JsonNode> data) {
        HashMap<String, List<JsonNode>> map = new HashMap<String, List<JsonNode>>();
        for (JsonNode entry : data) {
            JsonNode node = entry.get(tagKey);
            String tag = node == null ? null : node.textValue();
            ArrayList<JsonNode> tagData = (ArrayList<JsonNode>)map.get(tag);
            if (tagData == null) {
                tagData = new ArrayList<JsonNode>();
                map.put(tag, tagData);
            }
            tagData.add(entry);
        }
        return map;
    }

    @Override
    public JsonNode get(int index) {
        return (JsonNode)this.getData().get(index);
    }

    @Override
    public int size() {
        return this.getData().size();
    }
}

