/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed;

import java.lang.reflect.Method;
import java.util.Set;
import org.instancio.feed.Feed;
import org.instancio.feed.FeedSpec;
import org.instancio.internal.feed.InternalFeed;
import org.instancio.internal.feed.InternalFeedProxy;
import org.instancio.internal.feed.SpecMethod;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.Nullable;

public class InternalFeedSpecResolver {
    private final InternalFeed feed;
    private final Set<String> unmappedFeedProperties;

    public InternalFeedSpecResolver(Feed feed) {
        this.feed = InternalFeedProxy.asInternalFeed(feed);
        this.unmappedFeedProperties = this.feed.getFeedProperties();
    }

    public Set<String> getUnmappedFeedProperties() {
        return this.unmappedFeedProperties;
    }

    @Nullable
    public FeedSpec<?> getSpec(InternalNode node) {
        Class<?> feedClass = this.feed.getFeedContext().getFeedClass();
        String nodeFieldName = node.getField().getName();
        boolean nodeMatchedFeedProperty = this.unmappedFeedProperties.remove(nodeFieldName);
        Method customFeedSpecMethod = ReflectionUtils.getZeroArgMethod(feedClass, nodeFieldName);
        if (customFeedSpecMethod != null) {
            return this.feed.createSpec(new SpecMethod(customFeedSpecMethod), null);
        }
        return nodeMatchedFeedProperty ? this.feed.createSpec(nodeFieldName, node.getTargetClass()) : null;
    }
}

