/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.instancio.feed.Feed;
import org.instancio.internal.feed.InternalFeed;
import org.instancio.internal.feed.InternalFeedContext;
import org.instancio.internal.feed.InternalFeedProxyInvocationHandler;
import org.instancio.internal.feed.ResourceHandler;
import org.instancio.internal.feed.csv.CsvResourceHandler;
import org.instancio.internal.feed.json.JsonResourceHandler;
import org.instancio.settings.FeedFormatType;

public final class InternalFeedProxy {
    public static <F extends Feed> F forClass(InternalFeedContext<F> context) {
        ResourceHandler resourceHandler = InternalFeedProxy.getResourceHandler(context);
        InternalFeed feed = resourceHandler.createFeed(context);
        InternalFeedProxyInvocationHandler invocationHandler = new InternalFeedProxyInvocationHandler(feed);
        return (F)((Feed)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{context.getFeedClass(), InternalFeed.class}, (InvocationHandler)invocationHandler));
    }

    private static ResourceHandler getResourceHandler(InternalFeedContext<?> context) {
        if (context.getDataFormatType() == FeedFormatType.CSV) {
            return new CsvResourceHandler();
        }
        return new JsonResourceHandler();
    }

    public static InternalFeed asInternalFeed(Feed feed) {
        InternalFeedProxyInvocationHandler handler = (InternalFeedProxyInvocationHandler)Proxy.getInvocationHandler(feed);
        return handler.getProvider();
    }

    private InternalFeedProxy() {
    }
}

