/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.instancio.Assignment;
import org.instancio.GeneratorSpecProvider;
import org.instancio.OnCompleteCallback;
import org.instancio.TargetSelector;
import org.instancio.feed.Feed;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.context.AssignmentSelectorMap;
import org.instancio.internal.context.BooleanSelectorMap;
import org.instancio.internal.context.FeedSelectorMap;
import org.instancio.internal.context.GeneratorSelectorMap;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.context.ModelContextSelectorMap;
import org.instancio.internal.context.ModelContextSource;
import org.instancio.internal.context.OnCompleteCallbackSelectorMap;
import org.instancio.internal.context.PredicateSelectorMap;
import org.instancio.internal.context.SetModelSelectorHelper;
import org.instancio.internal.context.SubtypeSelectorMap;
import org.instancio.internal.util.TypeUtils;

public final class SelectorMaps {
    private final GeneratorContext generatorContext;
    private final AssignmentSelectorMap assignmentSelectorMap;
    private final GeneratorSelectorMap generatorSelectorMap;
    private final BooleanSelectorMap ignoreSelectorMap = new BooleanSelectorMap();
    private final BooleanSelectorMap withNullableSelectorMap = new BooleanSelectorMap();
    private final ModelContextSelectorMap setModelSelectorMap = new ModelContextSelectorMap();
    private final FeedSelectorMap feedSelectorMap = new FeedSelectorMap();
    private final OnCompleteCallbackSelectorMap onCompleteSelectorMap = new OnCompleteCallbackSelectorMap();
    private final PredicateSelectorMap filterSelectorMap = new PredicateSelectorMap();
    private final SubtypeSelectorMap subtypeSelectorMap = new SubtypeSelectorMap();

    SelectorMaps(ModelContextSource contextSource, GeneratorContext generatorContext) {
        this.generatorContext = generatorContext;
        this.assignmentSelectorMap = new AssignmentSelectorMap(generatorContext);
        this.generatorSelectorMap = new GeneratorSelectorMap(generatorContext);
        this.initSelectorMaps(contextSource);
    }

    void initSelectorMaps(ModelContextSource contextSource) {
        for (Map.Entry<TargetSelector, ModelContext> entry : contextSource.getSetModelMap().entrySet()) {
            this.copyToThisContext(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<TargetSelector, Object> entry : contextSource.getFeedMap().entrySet()) {
            Feed feed = (Feed)((Function)entry.getValue()).apply(this.generatorContext);
            this.feedSelectorMap.put(entry.getKey(), feed);
        }
        this.setModelSelectorMap.putAll(contextSource.getSetModelMap());
        this.ignoreSelectorMap.putAll(contextSource.getIgnoreSet());
        this.withNullableSelectorMap.putAll(contextSource.getWithNullableSet());
        this.onCompleteSelectorMap.putAll(contextSource.getOnCompleteMap());
        this.filterSelectorMap.putAll(contextSource.getFilterMap());
        this.generatorSelectorMap.putAllGeneratorSpecs(contextSource.getGeneratorSpecMap());
        this.generatorSelectorMap.putAllGenerators(contextSource.getGeneratorMap());
        this.assignmentSelectorMap.putAll(contextSource.getAssignmentMap());
        this.subtypeSelectorMap.putAll(contextSource.getSubtypeMap());
        this.subtypeSelectorMap.putAll(this.generatorSelectorMap.getSubtypeMap());
        this.subtypeSelectorMap.putAll(this.assignmentSelectorMap.getSubtypeMap());
    }

    private void copyToThisContext(TargetSelector modelTarget, ModelContext otherCtx) {
        TargetSelector resolvedSelector;
        ModelContextSource src = otherCtx.getContextSource();
        SetModelSelectorHelper setModelSelectorHelper = new SetModelSelectorHelper(TypeUtils.getRawType(otherCtx.getRootType().getType()));
        for (Map.Entry<TargetSelector, Function<GeneratorContext, Feed>> entry : src.getFeedMap().entrySet()) {
            resolvedSelector = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, entry.getKey());
            Feed feed = entry.getValue().apply(this.generatorContext);
            this.feedSelectorMap.put(resolvedSelector, feed);
        }
        for (Map.Entry<TargetSelector, Object> entry : src.getGeneratorMap().entrySet()) {
            resolvedSelector = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, entry.getKey());
            this.generatorSelectorMap.putGenerator(resolvedSelector, (Generator)entry.getValue());
        }
        for (Map.Entry<TargetSelector, Object> entry : src.getGeneratorSpecMap().entrySet()) {
            resolvedSelector = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, entry.getKey());
            this.generatorSelectorMap.putGeneratorSpec(resolvedSelector, (GeneratorSpecProvider)entry.getValue());
        }
        for (TargetSelector targetSelector : src.getIgnoreSet()) {
            resolvedSelector = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, targetSelector);
            this.ignoreSelectorMap.add(resolvedSelector);
        }
        for (TargetSelector targetSelector : src.getWithNullableSet()) {
            resolvedSelector = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, targetSelector);
            this.withNullableSelectorMap.add(resolvedSelector);
        }
        for (Map.Entry entry : src.getOnCompleteMap().entrySet()) {
            resolvedSelector = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, (TargetSelector)entry.getKey());
            this.onCompleteSelectorMap.put(resolvedSelector, (OnCompleteCallback)entry.getValue());
        }
        for (Map.Entry entry : src.getFilterMap().entrySet()) {
            resolvedSelector = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, (TargetSelector)entry.getKey());
            this.filterSelectorMap.put(resolvedSelector, (Predicate)entry.getValue());
        }
        for (Map.Entry entry : src.getAssignmentMap().entrySet()) {
            TargetSelector selector = (TargetSelector)entry.getKey();
            List assignments = (List)entry.getValue();
            ArrayList<Assignment> updatedAssignments = new ArrayList<Assignment>(assignments.size());
            for (Assignment assignment : assignments) {
                InternalAssignment a = (InternalAssignment)assignment;
                TargetSelector updatedOrigin = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, a.getOrigin());
                TargetSelector updatedDestination = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, a.getDestination());
                InternalAssignment updatedAssignment = a.toBuilder().origin(updatedOrigin).destination(updatedDestination).build();
                updatedAssignments.add(updatedAssignment);
            }
            TargetSelector resolvedSelector2 = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, selector);
            this.assignmentSelectorMap.put(resolvedSelector2, updatedAssignments);
        }
        for (Map.Entry entry : src.getSubtypeMap().entrySet()) {
            resolvedSelector = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, (TargetSelector)entry.getKey());
            this.subtypeSelectorMap.put(resolvedSelector, (Class)entry.getValue());
        }
        for (Map.Entry entry : src.getSetModelMap().entrySet()) {
            resolvedSelector = setModelSelectorHelper.applyModelSelectorScopes(modelTarget, (TargetSelector)entry.getKey());
            this.setModelSelectorMap.put(resolvedSelector, (ModelContext)entry.getValue());
            this.copyToThisContext(resolvedSelector, (ModelContext)entry.getValue());
        }
    }

    AssignmentSelectorMap getAssignmentSelectorMap() {
        return this.assignmentSelectorMap;
    }

    GeneratorSelectorMap getGeneratorSelectorMap() {
        return this.generatorSelectorMap;
    }

    BooleanSelectorMap getIgnoreSelectorMap() {
        return this.ignoreSelectorMap;
    }

    BooleanSelectorMap getWithNullableSelectorMap() {
        return this.withNullableSelectorMap;
    }

    ModelContextSelectorMap getSetModelSelectorMap() {
        return this.setModelSelectorMap;
    }

    FeedSelectorMap getFeedSelectorMap() {
        return this.feedSelectorMap;
    }

    OnCompleteCallbackSelectorMap getOnCompleteSelectorMap() {
        return this.onCompleteSelectorMap;
    }

    PredicateSelectorMap getFilterSelectorMap() {
        return this.filterSelectorMap;
    }

    SubtypeSelectorMap getSubtypeSelectorMap() {
        return this.subtypeSelectorMap;
    }

    public boolean allEmpty() {
        return !this.hasAssignments() && !this.hasGenerators() && !this.hasCallbacks() && !this.hasSetModels() && this.filterSelectorMap.getSelectorMap().isEmpty() && this.feedSelectorMap.getSelectorMap().isEmpty() && this.ignoreSelectorMap.getSelectorMap().isEmpty() && this.withNullableSelectorMap.getSelectorMap().isEmpty() && this.subtypeSelectorMap.getSelectorMap().isEmpty();
    }

    public boolean hasGenerators() {
        return !this.generatorSelectorMap.getSelectorMap().isEmpty();
    }

    public boolean hasCallbacks() {
        return !this.onCompleteSelectorMap.getSelectorMap().isEmpty();
    }

    public boolean hasAssignments() {
        return !this.assignmentSelectorMap.getOriginSelectors().getSelectorMap().isEmpty();
    }

    public boolean hasSetModels() {
        return !this.setModelSelectorMap.getSelectorMap().isEmpty();
    }
}

