/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Range;

final class AnnotationUtils {
    private AnnotationUtils() {
    }

    static void setSpecNullableToFalse(GeneratorSpec<?> spec) {
        if (spec instanceof AbstractGenerator) {
            ((AbstractGenerator)spec).nullable(false);
        }
    }

    static Range<Integer> calculateRange(int min, int max, int maxLimit) {
        int maxSize;
        int minSize;
        if (min > max) {
            throw Fail.withUsageError("invalid bean validation annotation: min must be less than or equal to max: min=%s, max=%s", min, max);
        }
        if (max == 0) {
            minSize = 0;
            maxSize = 0;
        } else if (min <= 1) {
            minSize = 1;
            maxSize = Math.min(max, maxLimit);
        } else if (AnnotationUtils.isMoreThanDouble(min, max)) {
            int tmpMax = min * 150 / 100;
            minSize = min;
            maxSize = Math.min(max, tmpMax);
        } else {
            minSize = min;
            maxSize = max;
        }
        return Range.of(minSize, maxSize);
    }

    private static boolean isMoreThanDouble(int min, int max) {
        return max - min - min > 0;
    }
}

