/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.instancio.internal.annotation.AbstractAnnotationLibraryFacade;
import org.instancio.internal.annotation.AnnotationLibraryFacade;
import org.instancio.internal.annotation.HibernateBeanValidationAnnotationLibraryFacade;
import org.instancio.internal.annotation.JakartaBeanValidationAnnotationLibraryFacade;
import org.instancio.internal.annotation.JakartaPersistenceAnnotationLibraryFacade;
import org.instancio.internal.annotation.JavaxBeanValidationAnnotationLibraryFacade;
import org.instancio.internal.annotation.JavaxPersistenceAnnotationLibraryFacade;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationLibraries {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationLibraries.class);
    private static final String JAVAX_PERSISTENCE_CLASS = "javax.persistence.Column";
    private static final String JAKARTA_PERSISTENCE_CLASS = "jakarta.persistence.Column";
    private static final String JAVAX_VALIDATOR_CLASS = "javax.validation.Validation";
    private static final String JAKARTA_VALIDATOR_CLASS = "jakarta.validation.Validation";
    private static final String HIBERNATE_VALIDATOR_CLASS = "org.hibernate.validator.HibernateValidator";

    private AnnotationLibraries() {
    }

    public static List<AnnotationLibraryFacade> discoverOnClasspath(ModelContext modelContext) {
        Settings settings = modelContext.getSettings();
        boolean jpaEnabled = settings.get(Keys.JPA_ENABLED);
        boolean beanValidationEnabled = settings.get(Keys.BEAN_VALIDATION_ENABLED);
        LOG.trace("Keys.BEAN_VALIDATION_ENABLED={}, Keys.JPA_ENABLED={}", (Object)beanValidationEnabled, (Object)jpaEnabled);
        ArrayList<AbstractAnnotationLibraryFacade> result = new ArrayList<AbstractAnnotationLibraryFacade>();
        if (jpaEnabled) {
            if (ReflectionUtils.loadClass(JAVAX_PERSISTENCE_CLASS) != null) {
                result.add(new JavaxPersistenceAnnotationLibraryFacade());
            }
            if (ReflectionUtils.loadClass(JAKARTA_PERSISTENCE_CLASS) != null) {
                result.add(new JakartaPersistenceAnnotationLibraryFacade());
            }
        }
        if (beanValidationEnabled) {
            if (ReflectionUtils.loadClass(HIBERNATE_VALIDATOR_CLASS) != null) {
                result.add(new HibernateBeanValidationAnnotationLibraryFacade());
            }
            if (ReflectionUtils.loadClass(JAKARTA_VALIDATOR_CLASS) != null) {
                result.add(new JakartaBeanValidationAnnotationLibraryFacade());
            }
            if (ReflectionUtils.loadClass(JAVAX_VALIDATOR_CLASS) != null) {
                result.add(new JavaxBeanValidationAnnotationLibraryFacade());
            }
        }
        return Collections.unmodifiableList(result);
    }
}

