/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.generator.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.instancio.generator.Hint;
import org.instancio.internal.ApiValidator;

public final class CollectionHint
implements Hint<CollectionHint> {
    private static final CollectionHint EMPTY_HINT = CollectionHint.builder().build();
    private final int generateElements;
    private final boolean nullableElements;
    private final boolean shuffle;
    private final boolean unique;
    private final List<?> withElements;

    private CollectionHint(Builder builder) {
        this.generateElements = builder.generateElements;
        this.nullableElements = builder.nullableElements;
        this.shuffle = builder.shuffle;
        this.unique = builder.unique;
        this.withElements = builder.withElements == null ? Collections.emptyList() : Collections.unmodifiableList(builder.withElements);
    }

    public static CollectionHint empty() {
        return EMPTY_HINT;
    }

    public int generateElements() {
        return this.generateElements;
    }

    public boolean nullableElements() {
        return this.nullableElements;
    }

    public boolean shuffle() {
        return this.shuffle;
    }

    public boolean unique() {
        return this.unique;
    }

    public <T> List<T> withElements() {
        return this.withElements;
    }

    public String toString() {
        return new StringJoiner(", ", "CollectionHint[", "]").add("generateElements=" + this.generateElements).add("nullableElements=" + this.nullableElements).add("shuffle=" + this.shuffle).add("withElements=" + this.withElements).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int generateElements;
        private boolean nullableElements;
        private boolean shuffle;
        private boolean unique;
        private List<Object> withElements;

        private Builder() {
        }

        public Builder generateElements(int generateElements) {
            ApiValidator.isTrue(generateElements >= 0, "Number of elements to generate must not be negative", new Object[0]);
            this.generateElements = generateElements;
            return this;
        }

        public Builder nullableElements(boolean nullableElements) {
            this.nullableElements = nullableElements;
            return this;
        }

        public Builder shuffle(boolean shuffle) {
            this.shuffle = shuffle;
            return this;
        }

        public Builder unique(boolean unique) {
            this.unique = unique;
            return this;
        }

        public <T> Builder withElements(List<? extends T> elements) {
            if (elements == null) {
                return this;
            }
            if (this.withElements == null) {
                this.withElements = new ArrayList<Object>();
            }
            this.withElements.addAll(elements);
            return this;
        }

        public CollectionHint build() {
            return new CollectionHint(this);
        }
    }
}

