/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.instancio.Scope;
import org.instancio.ScopeableSelector;
import org.instancio.Selector;
import org.instancio.TargetSelector;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.Flattener;
import org.instancio.internal.selectors.SelectorImpl;
import org.instancio.internal.selectors.TargetClass;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Format;

public final class PrimitiveAndWrapperSelectorImpl
implements Selector,
Flattener<TargetSelector> {
    private static final Map<Class<?>, String> API_METHOD_NAMES = PrimitiveAndWrapperSelectorImpl.getApiMethodNames();
    private final SelectorImpl primitive;
    private final SelectorImpl wrapper;

    public PrimitiveAndWrapperSelectorImpl(Class<?> primitiveType, Class<?> wrapperType) {
        this.primitive = SelectorImpl.builder().target(new TargetClass(primitiveType)).parent(this).build();
        this.wrapper = SelectorImpl.builder().target(new TargetClass(wrapperType)).parent(this).build();
    }

    public PrimitiveAndWrapperSelectorImpl(SelectorImpl primitive, SelectorImpl wrapper) {
        this.primitive = primitive;
        this.wrapper = wrapper;
    }

    public boolean isScoped() {
        return !this.primitive.getScopes().isEmpty();
    }

    public SelectorImpl getPrimitive() {
        return this.primitive;
    }

    public SelectorImpl getWrapper() {
        return this.wrapper;
    }

    @Override
    public ScopeableSelector lenient() {
        return new PrimitiveAndWrapperSelectorImpl(this.primitive.toBuilder().lenient().build(), this.wrapper.toBuilder().lenient().build());
    }

    @Override
    public Selector atDepth(int depth) {
        ApiValidator.validateDepth(depth);
        return new PrimitiveAndWrapperSelectorImpl(this.primitive.toBuilder().depth(depth).build(), this.wrapper.toBuilder().depth(depth).build());
    }

    @Override
    public List<TargetSelector> flatten() {
        return Arrays.asList(this.primitive, this.wrapper);
    }

    @Override
    public Selector within(Scope ... scopes) {
        List<Scope> scopeList = Arrays.asList(scopes);
        return new PrimitiveAndWrapperSelectorImpl(this.primitive.toBuilder().scopes(scopeList).build(), this.wrapper.toBuilder().scopes(scopeList).build());
    }

    @Override
    public Scope toScope() {
        throw Fail.withUsageError(String.format("method 'toScope()' is not supported for selector '%s'", this), new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrimitiveAndWrapperSelectorImpl)) {
            return false;
        }
        PrimitiveAndWrapperSelectorImpl that = (PrimitiveAndWrapperSelectorImpl)o;
        return this.primitive.equals(that.primitive) && this.wrapper.equals(that.wrapper);
    }

    public int hashCode() {
        int result = this.primitive.hashCode();
        result = 31 * result + this.wrapper.hashCode();
        return result;
    }

    public String toString() {
        String str = API_METHOD_NAMES.get(this.primitive.getTargetClass());
        if (!this.primitive.getScopes().isEmpty()) {
            str = str + ", " + Format.formatScopes(this.primitive.getScopes());
        } else if (this.primitive.getDepth() != null) {
            str = str + ".atDepth(" + this.primitive.getDepth() + ")";
        }
        return str;
    }

    private static Map<Class<?>, String> getApiMethodNames() {
        HashMap<Class<Comparable<Boolean>>, String> map = new HashMap<Class<Comparable<Boolean>>, String>();
        map.put(Boolean.TYPE, "allBooleans()");
        map.put(Character.TYPE, "allChars()");
        map.put(Byte.TYPE, "allBytes()");
        map.put(Short.TYPE, "allShorts()");
        map.put(Integer.TYPE, "allInts()");
        map.put(Long.TYPE, "allLongs()");
        map.put(Float.TYPE, "allFloats()");
        map.put(Double.TYPE, "allDoubles()");
        return Collections.unmodifiableMap(map);
    }
}

