/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.TemporalUnit;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.ZonedDateTimeSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.time.InstantGenerator;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.instancio.internal.util.Constants;

public class ZonedDateTimeGenerator
extends JavaTimeTemporalGenerator<ZonedDateTime>
implements ZonedDateTimeSpec {
    static final ZonedDateTime DEFAULT_MIN = Constants.DEFAULT_MIN.atZone(Constants.ZONE_OFFSET);
    static final ZonedDateTime DEFAULT_MAX = Constants.DEFAULT_MAX.atZone(Constants.ZONE_OFFSET);
    private final InstantGenerator delegate;

    public ZonedDateTimeGenerator(GeneratorContext context) {
        super(context, DEFAULT_MIN, DEFAULT_MAX);
        this.delegate = new InstantGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "zonedDateTime()";
    }

    @Override
    public ZonedDateTimeGenerator past() {
        super.past();
        return this;
    }

    @Override
    public ZonedDateTimeGenerator future() {
        super.future();
        return this;
    }

    @Override
    public ZonedDateTimeGenerator min(ZonedDateTime min) {
        super.min(min);
        return this;
    }

    @Override
    public ZonedDateTimeGenerator max(ZonedDateTime max) {
        super.max(max);
        return this;
    }

    @Override
    public ZonedDateTimeGenerator range(ZonedDateTime min, ZonedDateTime max) {
        super.range(min, max);
        return this;
    }

    @Override
    public ZonedDateTimeGenerator truncatedTo(TemporalUnit unit) {
        super.truncatedTo(unit);
        return this;
    }

    @Override
    public ZonedDateTimeGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    ZonedDateTime getLatestPast() {
        return ZonedDateTime.now(Constants.ZONE_OFFSET).minusSeconds(1L);
    }

    @Override
    ZonedDateTime getEarliestFuture() {
        return ZonedDateTime.now(Constants.ZONE_OFFSET).plusMinutes(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.validateStartEnd((ChronoZonedDateTime)this.min, (ChronoZonedDateTime)this.max);
    }

    @Override
    public ZonedDateTime tryGenerateNonNull(Random random) {
        this.delegate.range(((ZonedDateTime)this.min).toInstant(), ((ZonedDateTime)this.max).toInstant());
        ZonedDateTime result = ZonedDateTime.ofInstant(this.delegate.tryGenerateNonNull(random), Constants.ZONE_OFFSET);
        return this.truncateTo == null ? result : result.truncatedTo(this.truncateTo);
    }
}

