/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.internet;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.Ip4Spec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.Fail;

public class Ip4Generator
extends AbstractGenerator<String>
implements Ip4Spec {
    private String cidr;

    public Ip4Generator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "ip4()";
    }

    @Override
    public Ip4Generator fromCidr(String cidr) {
        this.cidr = ApiValidator.notNull(cidr, "CIDR must not be null");
        return this;
    }

    @Override
    public Ip4Generator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        if (this.cidr == null) {
            return this.generateAny(random);
        }
        try {
            return this.generateFromCidr(random);
        }
        catch (Exception ex) {
            throw Fail.withUsageError(String.format("error generating IPv4 address from: '%s'", this.cidr), ex);
        }
    }

    private String generateAny(Random random) {
        return String.format("%d.%d.%d.%d", random.intRange(1, 255), random.intRange(0, 255), random.intRange(0, 255), random.intRange(0, 255));
    }

    private String generateFromCidr(Random random) {
        String[] cidrValue = this.cidr.split("/");
        String[] buf = cidrValue[0].split("\\.");
        byte[] ip = new byte[]{(byte)Integer.parseInt(buf[0]), (byte)Integer.parseInt(buf[1]), (byte)Integer.parseInt(buf[2]), (byte)Integer.parseInt(buf[3])};
        int value = -1 << 32 - Integer.parseInt(cidrValue[1]);
        byte[] subnet = new byte[]{(byte)(value >>> 24), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        byte[] from = new byte[4];
        byte[] to = new byte[4];
        for (int i = 0; i < to.length; ++i) {
            from[i] = (byte)(ip[i] & subnet[i]);
            to[i] = (byte)(ip[i] | ~subnet[i]);
        }
        return String.format("%d.%d.%d.%d", random.intRange(Byte.toUnsignedInt(from[0]), Byte.toUnsignedInt(to[0])), random.intRange(Byte.toUnsignedInt(from[1]), Byte.toUnsignedInt(to[1])), random.intRange(Byte.toUnsignedInt(from[2]), Byte.toUnsignedInt(to[2])), random.intRange(Byte.toUnsignedInt(from[3]), Byte.toUnsignedInt(to[3])));
    }
}

