/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.id.bra;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.bra.CnpjSpec;
import org.instancio.internal.generator.AbstractGenerator;

public class CnpjGenerator
extends AbstractGenerator<String>
implements CnpjSpec {
    private static final int CNPJ_LENGTH = 12;
    private boolean format;

    public CnpjGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public CnpjGenerator formatted() {
        this.format = true;
        return this;
    }

    @Override
    public String apiMethod() {
        return "cnpj()";
    }

    @Override
    public CnpjGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        String baseCnpj = random.digits(12);
        int firstDigitVerifier = this.generateFirstDigit(baseCnpj);
        int secondDigitVerifier = this.generateSecondDigit(baseCnpj, firstDigitVerifier);
        if (!this.format) {
            return baseCnpj + firstDigitVerifier + secondDigitVerifier;
        }
        return this.format(baseCnpj, String.format("%d%d", firstDigitVerifier, secondDigitVerifier));
    }

    private String format(String baseCNPJ, String digits) {
        return baseCNPJ.substring(0, 2) + '.' + baseCNPJ.substring(2, 5) + '.' + baseCNPJ.substring(5, 8) + '/' + baseCNPJ.substring(8, 12) + '-' + digits;
    }

    private int generateFirstDigit(String baseCnpj) {
        return this.generateDigit(baseCnpj, 5);
    }

    private int generateSecondDigit(String baseCnpj, int firstDigit) {
        return this.generateDigit(baseCnpj + firstDigit, 6);
    }

    private int generateDigit(String baseCnpj, int initialWeight) {
        int weight = initialWeight;
        int sum = 0;
        for (char digit : baseCnpj.toCharArray()) {
            sum += Character.getNumericValue(digit) * weight;
            if (--weight != 1) continue;
            weight = 9;
        }
        int mod = sum % 11;
        if (mod < 2) {
            return 0;
        }
        return 11 - mod;
    }
}

