/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import org.instancio.generator.Generator;
import org.instancio.generator.Hints;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.EmitGeneratorHelper;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.SpiGeneratorResolver;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.misc.EmitGenerator;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public final class UserSuppliedGeneratorProcessor {
    private final ModelContext context;
    private final GeneratorResolver generatorResolver;
    private final SpiGeneratorResolver spiGeneratorResolver;
    private final EmitGeneratorHelper emitGeneratorHelper;

    public UserSuppliedGeneratorProcessor(ModelContext context, GeneratorResolver generatorResolver, SpiGeneratorResolver spiGeneratorResolver) {
        this.context = context;
        this.generatorResolver = generatorResolver;
        this.spiGeneratorResolver = spiGeneratorResolver;
        this.emitGeneratorHelper = new EmitGeneratorHelper(context);
    }

    @NotNull
    GeneratorResult getGeneratorResult(@NotNull InternalNode node, Generator<?> g) {
        boolean nullable;
        Generator<?> generator = this.processGenerator(g, node);
        if (generator instanceof EmitGenerator) {
            return this.emitGeneratorHelper.getResult((EmitGenerator)generator, node);
        }
        Hints hints = generator.hints();
        InternalGeneratorHint internalHint = hints.get(InternalGeneratorHint.class);
        boolean bl = nullable = internalHint != null && internalHint.nullableResult();
        if (this.context.getRandom().diceRoll(nullable)) {
            return GeneratorResult.nullResult();
        }
        Object value = generator.generate(this.context.getRandom());
        return GeneratorResult.create(value, hints);
    }

    private Generator<?> processGenerator(Generator<?> generator, InternalNode node) {
        ApiValidator.validateGeneratorUsage(node, generator);
        if (generator instanceof ArrayGenerator) {
            ((ArrayGenerator)generator).subtype((Class)node.getTargetClass());
        } else if (generator instanceof AbstractGenerator) {
            AbstractGenerator g = (AbstractGenerator)generator;
            if (!g.isDelegating()) {
                return generator;
            }
            Hints hints = generator.hints();
            InternalGeneratorHint internalHint = hints.get(InternalGeneratorHint.class);
            Generator<?> delegate = this.resolveDelegate(node, internalHint);
            if (delegate instanceof AbstractGenerator) {
                boolean nullable = ((AbstractGenerator)generator).isNullable();
                ((AbstractGenerator)delegate).nullable(nullable);
            }
            return GeneratorDecorator.replaceHints(delegate, hints);
        }
        return generator;
    }

    @NotNull
    private Generator<?> resolveDelegate(InternalNode node, InternalGeneratorHint internalHint) {
        Class<?> targetClass = ObjectUtils.defaultIfNull(internalHint.targetClass(), node.getTargetClass());
        InternalNode actualNode = targetClass == node.getTargetClass() ? node : node.toBuilder().targetClass(targetClass).build();
        Generator<?> generator = this.spiGeneratorResolver.getSpiGenerator(node);
        if (generator == null) {
            generator = this.generatorResolver.getCached(actualNode);
        }
        return generator;
    }
}

